/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.support.provider.mq;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitesland.support.provider.mq.SyncMqMessage;
import java.io.Serializable;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SyncMqSender {
    private static MessageQueueTemplate messageQueueTemplate = (MessageQueueTemplate)SpringContextHolder.getBean(MessageQueueTemplate.class);

    public static void send(final Long entityId, final String entityKey, final String entityType, final String outSysType) {
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                messageQueueTemplate.publishMessage("yst-supp", entityType + "__" + outSysType, (Serializable)new SyncMqMessage(entityId, entityKey, entityType, outSysType));
            }
        });
    }

    public static void send(final String entityType, final String outSysType, final String data) {
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                messageQueueTemplate.publishMessage("yst-supp", entityType + "__" + outSysType, (Serializable)new SyncMqMessage(entityType, outSysType, data));
            }
        });
    }
}

