/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.support.provider.pri.cache;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import com.elitescloud.boot.util.StrUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.item.dto.ItmItemIcDTO;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.support.provider.pri.cache.client.PriPriceCache;
import com.elitesland.support.provider.pri.cache.client.PriPriceCacheClient;
import com.elitesland.support.provider.pri.cache.client.PriPriceConfCache;
import com.elitesland.support.provider.pri.cache.client.PriPricePriorityConfCache;
import com.elitesland.support.provider.pri.cache.client.PriceClientConvert;
import com.elitesland.support.provider.pri.service.SuppPriPriceRpcService;
import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;
import com.elitesland.support.provider.pri.service.param.ItmPriPriceRpcDtoParam;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriPriceCacheService {
    private static final Logger log = LoggerFactory.getLogger(PriPriceCacheService.class);
    private static ItmItemRpcService itmItemRpcService;
    private static UdcProvider udcProvider;
    private static SuppPriPriceRpcService priPriceRpcService;
    private static String priFetchMethod;
    public static List<String> priceTypes;

    public static ApiResult<List<PriPriceRpcDTO>> findPriPrice(List<ItmPriPriceRpcDtoParam> params, SuppPriPriceRpcService rpcServiceImpl, ItmItemRpcService itemServiceImpl) {
        priPriceRpcService = rpcServiceImpl;
        itmItemRpcService = itemServiceImpl;
        return PriPriceCacheService.findPriPrice(params);
    }

    public static ApiResult<List<PriPriceRpcDTO>> findPriPrice(List<ItmPriPriceRpcDtoParam> params) {
        log.info("\u7f13\u5b58\u53d6\u4ef7\u63a5\u53e3\uff0c\u53c2\u6570\uff1a" + JSON.toJSONString(params));
        if (priFetchMethod == null) {
            priFetchMethod = SpringUtil.getProperty((String)"yst.support.price.ftype", (String)"redis");
        }
        if (!"redis".equals(priFetchMethod) || !PriPriceCacheClient.cacheFinished().booleanValue()) {
            if (priPriceRpcService == null) {
                priPriceRpcService = (SuppPriPriceRpcService)SpringUtil.getBean(SuppPriPriceRpcService.class);
            }
            return priPriceRpcService.findPriPrice(params);
        }
        long start = System.currentTimeMillis();
        if (CollectionUtil.isEmpty(params)) {
            return ApiResult.ok(new ArrayList());
        }
        PriPriceCacheService.checkFindDtoByParamParameter(params);
        ArrayList<PriPriceRpcDTO> result = new ArrayList<PriPriceRpcDTO>();
        List<ItmPriPriceRpcDtoParam> notTodayParams = params.stream().filter(i -> i.getValidTime() != null && !LocalDateTimeUtil.isSameDay((LocalDateTime)LocalDateTime.now(), (LocalDateTime)i.getValidTime())).collect(Collectors.toList());
        List notEnableParams = params.stream().filter(i -> i.getPriceStatus() != null && Objects.equals(i.getPriceStatus(), "DISABLE")).collect(Collectors.toList());
        if (!notTodayParams.isEmpty() || !notEnableParams.isEmpty()) {
            notTodayParams.addAll(notEnableParams);
            if (priPriceRpcService == null) {
                priPriceRpcService = (SuppPriPriceRpcService)SpringUtil.getBean(SuppPriPriceRpcService.class);
            }
            List dbFindPriceList = (List)priPriceRpcService.findPriPrice(notTodayParams).computeData();
            result.addAll(dbFindPriceList);
            List dbParamUuids = notTodayParams.stream().map(i -> i.getUuid()).collect(Collectors.toList());
            params = params.stream().filter(i -> !dbParamUuids.contains(i.getUuid())).collect(Collectors.toList());
        }
        if (params.isEmpty()) {
            log.info("\u7f13\u5b58\u83b7\u53d6\u4ef7\u683c\u7ed3\u679c\uff0c\u65e0\u7f13\u5b58\u67e5\u8be2\uff1a" + JSON.toJSONString(result));
            return ApiResult.ok(result);
        }
        Long tenantId = TenantClient.getSessionTenant().getId();
        String dateStr = LocalDateTimeUtil.format((LocalDate)LocalDate.now(), (String)"yyyyMMdd");
        PriPriceCacheService.fillUpItem(params, null);
        Map<String, String> flowNoCache = PriPriceCacheService.getFlowNoCache();
        List<PriPriceConfCache> confCache = PriPriceCacheClient.findConfCache();
        Map<String, List<PriPriceConfCache>> priConfigMap = confCache.stream().collect(Collectors.groupingBy(i -> i.getPriceType()));
        HashMap redisKeyMap = new HashMap();
        HashMap<String, String> priceTypePathMap = new HashMap<String, String>();
        ArrayList<String> redisKeys = new ArrayList<String>();
        for (ItmPriPriceRpcDtoParam param : params) {
            List<String> currentPriceTypes = priceTypes;
            if (StringUtils.isNotBlank((CharSequence)param.getPriceType())) {
                currentPriceTypes = Arrays.asList(param.getPriceType());
            }
            for (String priceType : priConfigMap.keySet()) {
                if (!currentPriceTypes.contains(priceType)) continue;
                for (PriPriceConfCache priPriceConfCache : priConfigMap.get(priceType)) {
                    String value;
                    ArrayList<String> elementPaths = new ArrayList<String>();
                    ArrayList elementPathValues = new ArrayList();
                    if (priPriceConfCache.getPriceElement().contains("OU_CODE") && !MapUtil.isEmpty(flowNoCache) && !Objects.isNull(flowNoCache.get("OU_CODE")) && !StrUtil.isBlank((CharSequence)(value = param.getOuCode()))) {
                        elementPaths.add("OU_CODE");
                        elementPathValues.add(value);
                    }
                    if (priPriceConfCache.getPriceElement().contains("ITEM_CODE") && !MapUtil.isEmpty(flowNoCache) && !Objects.isNull(flowNoCache.get("ITEM_CODE")) && !StrUtil.isBlank((CharSequence)(value = param.getItemCode()))) {
                        elementPaths.add("ITEM_CODE");
                        elementPathValues.add(value);
                    }
                    if (priPriceConfCache.getPriceElement().contains("CUSTOM_CODE") && !MapUtil.isEmpty(flowNoCache) && !Objects.isNull(flowNoCache.get("CUSTOM_CODE")) && !StrUtil.isBlank((CharSequence)(value = param.getCustCode()))) {
                        elementPaths.add("CUSTOM_CODE");
                        elementPathValues.add(value);
                    }
                    if (priPriceConfCache.getPriceElement().contains("SALE_ORG") && !MapUtil.isEmpty(flowNoCache) && !Objects.isNull(flowNoCache.get("SALE_ORG")) && !StrUtil.isBlank((CharSequence)(value = param.getSaleOrg()))) {
                        elementPaths.add("SALE_ORG");
                        elementPathValues.add(value);
                    }
                    if (priPriceConfCache.getPriceElement().contains("DISTRIBUTION_CHANNEL") && !MapUtil.isEmpty(flowNoCache) && !Objects.isNull(flowNoCache.get("DISTRIBUTION_CHANNEL")) && !StrUtil.isBlank((CharSequence)(value = param.getSaleChannel()))) {
                        elementPaths.add("DISTRIBUTION_CHANNEL");
                        elementPathValues.add(value);
                    }
                    if (priPriceConfCache.getPriceElement().contains("REGION") && !MapUtil.isEmpty(flowNoCache) && !Objects.isNull(flowNoCache.get("REGION")) && !StrUtil.isBlank((CharSequence)(value = param.getRegion()))) {
                        elementPaths.add("REGION");
                        elementPathValues.add(value);
                    }
                    if (priPriceConfCache.getPriceElement().contains("UOM") && !MapUtil.isEmpty(flowNoCache) && !Objects.isNull(flowNoCache.get("UOM")) && !StrUtil.isBlank((CharSequence)(value = param.getUom()))) {
                        elementPaths.add("UOM");
                        elementPathValues.add(value);
                    }
                    if (priPriceConfCache.getPriceElement().contains("CURR_CODE") && !MapUtil.isEmpty(flowNoCache) && !Objects.isNull(flowNoCache.get("CURR_CODE")) && !StrUtil.isBlank((CharSequence)(value = param.getCurrCode()))) {
                        elementPaths.add("CURR_CODE");
                        elementPathValues.add(value);
                    }
                    if (elementPaths.isEmpty() || !PriPriceCacheService.allBeIncluded(priPriceConfCache.getPriceElement(), elementPaths)) continue;
                    String elementPathStr = String.join((CharSequence)":", elementPaths);
                    String redisKey = PriPriceCache.getCacheKey(tenantId, dateStr, priceType, elementPathStr, String.join((CharSequence)":", elementPathValues));
                    if (!redisKeyMap.containsKey(param.getUuid())) {
                        redisKeyMap.put(param.getUuid(), new ArrayList());
                    }
                    ((ArrayList)redisKeyMap.get(param.getUuid())).add(redisKey);
                    redisKeys.add(redisKey);
                    priceTypePathMap.put(priceType + priPriceConfCache.getPriority(), elementPathStr);
                }
            }
        }
        if (redisKeyMap.isEmpty()) {
            log.info("\u7f13\u5b58\u83b7\u53d6\u4ef7\u683c\u7ed3\u679c\uff1a" + JSON.toJSONString(result));
            return ApiResult.ok(result);
        }
        List priceClsList = params.stream().filter(i -> StringUtils.isBlank((CharSequence)i.getPriceType())).map(i -> i.getPriceCls()).distinct().collect(Collectors.toList());
        Map<String, PriPricePriorityConfCache> priorityConfDOMap = null;
        if (!priceClsList.isEmpty()) {
            List<PriPricePriorityConfCache> priorityConfigList = PriPriceCacheClient.findPriorityConfCache();
            log.info("\u4ef7\u683c\u4f18\u5148\u7ea7\u53d6\u4ef7\u67e5\u8be2\u7ed3\u679c\uff1b" + JSON.toJSONString(priorityConfigList));
            priorityConfDOMap = priorityConfigList.stream().collect(Collectors.toMap(i -> i.getPriceCls(), i -> i, (o, n) -> n));
        }
        List<PriPriceCache> allPrice = PriPriceCacheClient.findPrice(redisKeys);
        Map<String, PriPriceCache> priceCacheMap = allPrice.stream().collect(Collectors.toMap(i -> i.getCacheKey(tenantId, dateStr), i -> i, (o, n) -> n));
        Map<String, ItmPriPriceRpcDtoParam> paramMap = params.stream().collect(Collectors.toMap(i -> i.getUuid(), i -> i));
        for (String uuid : redisKeyMap.keySet()) {
            ArrayList<PriPriceCache> currentPrice = new ArrayList<PriPriceCache>();
            for (String key : (ArrayList)redisKeyMap.get(uuid)) {
                if (!priceCacheMap.containsKey(key) || priceCacheMap.get(key) == null) continue;
                currentPrice.add(priceCacheMap.get(key));
            }
            PriPricePriorityConfCache priPricePriorityConfCache = null;
            if (priorityConfDOMap != null) {
                priPricePriorityConfCache = priorityConfDOMap.get(paramMap.get(uuid).getPriceCls());
            }
            result.addAll(PriPriceCacheService.buildResult(paramMap.get(uuid), currentPrice, priConfigMap, priPricePriorityConfCache, priceTypePathMap));
        }
        log.info("\u7f13\u5b58\u83b7\u53d6\u4ef7\u683c\u7ed3\u679c\uff1a" + JSON.toJSONString(result) + "\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return ApiResult.ok(result);
    }

    public static List<PriPriceRpcDTO> buildResult(ItmPriPriceRpcDtoParam param, List<PriPriceCache> priceResult, Map<String, List<PriPriceConfCache>> priConfigMap, PriPricePriorityConfCache priPricePriorityConfCache, Map<String, String> priceTypePathMap) {
        List<PriPriceCache> caches = PriPriceCacheService.filterPriceRpcDtoByPriceCfg(priceResult, priceTypePathMap, priConfigMap);
        List<PriPriceRpcDTO> currentPriceResult = PriceClientConvert.INSTANCE.cacheToRpcDTO(caches);
        if (StringUtils.isNotBlank((CharSequence)param.getPriceType())) {
            for (PriPriceRpcDTO priPriceRpcDTO : currentPriceResult) {
                priPriceRpcDTO.setPriceCls(param.getPriceCls());
                priPriceRpcDTO.setUuid(param.getUuid());
            }
            return currentPriceResult;
        }
        String priceCls = param.getPriceCls();
        if (priPricePriorityConfCache == null) {
            log.warn("\u4ef7\u683c\u7c7b\u522b" + priceCls + "\u65e0\u53d6\u4ef7\u914d\u7f6e\uff0c\u5ffd\u7565\u8bf7\u6c42\uff1a" + JSON.toJSONString((Object)param));
        } else {
            PriPriceRpcDTO priceConfigResult = PriPriceCacheService.findPriceConfigResult(currentPriceResult, priPricePriorityConfCache);
            if (priceConfigResult != null) {
                priceConfigResult.setUuid(param.getUuid());
                return List.of(priceConfigResult);
            }
        }
        return new ArrayList<PriPriceRpcDTO>();
    }

    private static PriPriceRpcDTO findPriceConfigResult(List<PriPriceRpcDTO> currentPriceResult, PriPricePriorityConfCache confDO) {
        PriPriceRpcDTO firstPriPriceRpcDTO = CollectionUtils.isEmpty(currentPriceResult) ? null : currentPriceResult.get(0);
        HashMap priceTypeMap = CollectionUtils.isEmpty(currentPriceResult) ? new HashMap() : currentPriceResult.stream().collect(Collectors.toMap(PriPriceRpcDTO::getPriceType, t -> t, (t1, t2) -> t1));
        String[] split = confDO.getPricePriority().split("&&");
        PriPriceRpcDTO result = null;
        if (confDO.getConfigType().equals("10")) {
            for (String priceType : split) {
                PriPriceRpcDTO priPriceRpcDTO = (PriPriceRpcDTO)priceTypeMap.get(priceType);
                if (priPriceRpcDTO == null) continue;
                result = priPriceRpcDTO;
                break;
            }
        } else {
            BigDecimal totalPrice = BigDecimal.ZERO;
            BigDecimal totalNetPrice = BigDecimal.ZERO;
            boolean hasImportantPrice = true;
            for (int i = 0; i < split.length; i += 2) {
                int k = i;
                PriPriceRpcDTO priPriceRpcDTO = (PriPriceRpcDTO)priceTypeMap.get(split[k]);
                if (priPriceRpcDTO == null) {
                    if (!priPriceRpcDTO.getPriceType().equals(confDO.getImportantPriceType())) continue;
                    log.warn("\u65e0\u91cd\u70b9\u5173\u6ce8\u4ef7\uff1a" + confDO.getImportantPriceType());
                    hasImportantPrice = false;
                    break;
                }
                if (i == 0) {
                    totalPrice = totalPrice.add(priPriceRpcDTO.getPrice());
                    totalNetPrice = totalNetPrice.add(priPriceRpcDTO.getNetPrice());
                    continue;
                }
                if (Objects.equals(split[i - 1], "ADD")) {
                    totalPrice = totalPrice.add(priPriceRpcDTO.getPrice());
                    totalNetPrice = totalNetPrice.add(priPriceRpcDTO.getNetPrice());
                    continue;
                }
                totalPrice = totalPrice.subtract(priPriceRpcDTO.getPrice());
                totalNetPrice = totalNetPrice.subtract(priPriceRpcDTO.getNetPrice());
            }
            if (hasImportantPrice && Objects.nonNull(firstPriPriceRpcDTO)) {
                result = PriceClientConvert.INSTANCE.rpcDtoToRpcPriceDto(firstPriPriceRpcDTO);
                result.setPrice(totalPrice);
                result.setNetPrice(totalNetPrice);
                result.setChildPrice(currentPriceResult);
                result.setPriceType(null);
                result.setPriceResultNote(confDO.getImportantPriceType());
            }
        }
        if (result == null && StringUtils.isNotBlank((CharSequence)confDO.getBasePriceType())) {
            result = (PriPriceRpcDTO)priceTypeMap.get(confDO.getBasePriceType());
            if (result != null) {
                result.setPriceResultNote("\u53d6\u515c\u5e95\u4ef7 " + confDO.getBasePriceType());
            } else {
                log.info("\u53d6\u515c\u5e95\u4ef7 " + confDO.getBasePriceType() + " \u672a\u914d\u7f6e\u8be5\u4ef7\u683c");
            }
        }
        if (result != null) {
            result.setPriceCls(confDO.getPriceCls());
        }
        return result;
    }

    public static List<PriPriceCache> filterPriceRpcDtoByPriceCfg(List<PriPriceCache> priceRpcDTOList, Map<String, String> priceTypePathMap, Map<String, List<PriPriceConfCache>> priConfigMap) {
        ArrayList<PriPriceCache> result = new ArrayList<PriPriceCache>();
        if (CollectionUtils.isEmpty(priceRpcDTOList)) {
            return result;
        }
        block0: for (String priceType : priConfigMap.keySet()) {
            List<PriPriceConfCache> priPriceConfCaches = priConfigMap.get(priceType);
            priPriceConfCaches.sort(new Comparator<PriPriceConfCache>(){

                @Override
                public int compare(PriPriceConfCache o1, PriPriceConfCache o2) {
                    return o1.getPriority() - o2.getPriority();
                }
            });
            for (PriPriceConfCache priPriceConfCach : priPriceConfCaches) {
                PriPriceCache priPriceRpcDTO;
                String elementCfgPath = priceTypePathMap.get(priceType + priPriceConfCach.getPriority());
                if (StrUtil.isBlank((CharSequence)elementCfgPath) || (priPriceRpcDTO = priceRpcDTOList.stream().filter(item -> priceType.equals(item.getPriceType()) && elementCfgPath.equals(item.getElementPath())).findFirst().orElseGet(() -> null)) == null) continue;
                result.add(priPriceRpcDTO);
                continue block0;
            }
        }
        return result;
    }

    private static boolean allBeIncluded(String priceElementCfg, List<String> elementPaths) {
        if (StringUtils.isBlank((CharSequence)priceElementCfg)) {
            return true;
        }
        String[] split = priceElementCfg.split("\\+");
        for (int i = 0; i < split.length; ++i) {
            if (elementPaths.contains(split[i])) continue;
            return false;
        }
        return true;
    }

    public static void checkFindDtoByParamParameter(List<ItmPriPriceRpcDtoParam> param) {
        param.stream().forEach(item -> {
            if (StringUtils.isBlank((CharSequence)item.getPriceType())) {
                Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)item.getPriceCls()), (String)"\u4ef7\u683c\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            Assert.isTrue((StringUtils.isNotBlank((CharSequence)item.getItemCode()) || item.getItemId() != null ? 1 : 0) != 0, (String)"\u5546\u54c1id\u548c\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)item.getUom()), (String)"\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)item.getCurrCode()), (String)"\u8d27\u5e01\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (StrUtil.isBlank((CharSequence)item.getUuid())) {
                item.setUuid(UUID.randomUUID().toString());
            }
        });
        List collect = param.stream().filter(i -> StringUtils.isNotBlank((CharSequence)i.getUuid())).collect(Collectors.toList());
        Assert.isTrue(((long)collect.size() == collect.stream().distinct().count() ? 1 : 0) != 0, (String)"\u53d6\u4ef7\u4f20\u53c2\u4e2did\u6807\u8bc6\u4e0d\u5141\u8bb8\u91cd\u590d", (Object[])new Object[0]);
    }

    public static void fillUpItem(List<ItmPriPriceRpcDtoParam> params, ItmItemRpcService rpcService) {
        List<Long> itemIds = params.stream().filter(item -> item.getItemId() != null && StringUtils.isBlank((CharSequence)item.getItemCode())).map(item -> item.getItemId()).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(itemIds)) {
            if (itmItemRpcService == null) {
                itmItemRpcService = rpcService != null ? rpcService : (ItmItemRpcService)SpringUtil.getBean(ItmItemRpcService.class);
            }
            List<ItmItemIcDTO> icItem = itmItemRpcService.findIcItem(itemIds);
            List existIds = icItem.stream().map(item -> item.getId()).collect(Collectors.toList());
            List notExistsIds = itemIds.stream().filter(i -> !existIds.contains(i)).collect(Collectors.toList());
            if (!notExistsIds.isEmpty()) {
                throw new BusinessException("\u5546\u54c1id" + JSON.toJSONString(notExistsIds) + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            }
            Map<Long, String> icMap = icItem.stream().collect(Collectors.toMap(i -> i.getId(), i -> i.getItemCode()));
            for (ItmPriPriceRpcDtoParam param : params) {
                if (StrUtil.isNotBlank((CharSequence)param.getItemCode())) continue;
                param.setItemCode(icMap.get(param.getItemId()));
            }
        }
    }

    public static Map<String, String> getFlowNoCache() {
        if (udcProvider == null) {
            udcProvider = (UdcProvider)SpringUtil.getBean(UdcProvider.class);
        }
        Map map = udcProvider.getValueMapByUdcCode("yst-supp", "FIXED_PRICE_ELEMENT");
        return map;
    }

    static {
        priceTypes = List.of("MAIN_PRICE", "SALE_PRICE", "CHANNEL_PRICE", "INTERNAL_SETTLEMENT_PRICE", "NEGO_PRICE", "PROM_PRICE", "RETAIL_PRICE");
    }
}

