package com.elitesland.support.provider.org.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@ApiModel("门店列表返回参数")
public class OrgStoreInvRpcDTO implements  Serializable {


    private static final long serialVersionUID = 6091280637456576234L;

    @ApiModelProperty("门店id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty("门店类型")
    private String storeType;

    @ApiModelProperty("地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;

    @ApiModelProperty("发票类型")
    private String invType;

    @ApiModelProperty("开票抬头")
    private String invTypeName;

    @ApiModelProperty("开票地址")
    private String invAddress;

    @ApiModelProperty("开票抬头")
    private String invTitle;

    @ApiModelProperty("开票电话")
    private String invTel;

    @ApiModelProperty("开票邮箱")
    private String invEmail;

    @ApiModelProperty("开票联系人电话")
    private String invPicPhone;

    @ApiModelProperty("开票银行名称")
    private String invBankName;

    @ApiModelProperty("开票银行支行")
    private String invBankBranch;

    @ApiModelProperty("开票银行账号")
    private String invBankAcc;

    @ApiModelProperty("税号")
    private String taxerNo;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("区域")
    private String region;

}
