package com.elitesland.support.provider.org.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
//import java.util.Map;

/**
 入参：门店创建时间、最近更新时间、门店编码（选填）
 2个时间二选一的必填；
 查询时间段限制暂定1个月；
 做成分页查询；
 */
@Data
public class OrgStoreParam extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = 3344534498352255891L;


    @ApiModelProperty("门店编码，批量查询")
    private List<String> storeCodeList;
    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建开始时间")
    private LocalDateTime createTimeStart;
    @ApiModelProperty("记录创建结束时间")
    private LocalDateTime createTimeEnd;

    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新开始时间")
    private LocalDateTime modifyTimeStart;
    @ApiModelProperty("记录最后更新结束时间")
    private LocalDateTime modifyTimeEnd;


    @ApiModelProperty("门店类型")
    private List<String> storeTypeList;

}
