package com.elitesland.support.provider.org.service;

import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.org.dto.*;
import com.elitesland.support.provider.org.param.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author Chris
 * @date 2021-04-28
 */
@FeignClient(name = Application.NAME, path = Application.PATH + OrgOuRpcService.PATH)
@Validated
public interface OrgOuRpcService {
    String PATH = "/orgOuRpc";

    /**
     * 获取公司信息列表，该接口一般应用与如下场景
     * 1. 第三方通过id或者code获取一些基本信息，用于后端处理
     * 2. 检查数据是否存在，存在则会返回数据，不存在则不会返回数据
     * <p>
     * 如果传入的查询参数均为空，则不返回任何数据，防止获取全部数据
     * <p>
     * 注意接口返回数据没有上限控制，请合理使用，保证效能
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 查询条件，每个条件使用 and 关联
     * @return dto
     */
    @PostMapping("/findOuDto")
    List<OrgOuRpcDTO> findOuDtoByParam(@RequestBody OrgOuRpcDtoParam param);

    @PostMapping("/findOuDtoById")
    List<OrgOuRpcDTO> findOuDtoById(Long id);

    @PostMapping("/findSimple")
    List<OrgOuRpcSimpleDTO> findSimpleOuDto(@RequestBody List<Long> ids);

    /**
     * 根据公司类型获取公司详情信息，包含公司编码名称、银行信息，后续可扩展
     *
     * @param ouType 公司类型，非空
     * @return 该类型的公司集合
     */
    @PostMapping("/findOuBankDetail")
    List<OrgOuBankRpcDTO> findOuBankDetail(@RequestParam("ouType") String ouType, @RequestBody List<Long> ouIds);

    /**
     * 新增银行信息
     *
     * @param addrNo                     地址号，非空
     * @param orgAddrBankAccRpcSaveParam 银行信息
     */
    @PostMapping("/createBankItem")
    void createBankItem(@RequestParam("addrNo") Long addrNo, @RequestBody OrgAddrBankAccRpcSaveParam orgAddrBankAccRpcSaveParam);

    /**
     * 新增公司
     *
     * @param param
     * @return
     */
    @PostMapping("/createOu")
    String createOu(@RequestBody OrgOuRpcSaveParam param);

    @PostMapping("/selectComOuByParam")
    List<OrgOuComRpcDTO> selectComOuByParam(@RequestBody OrgOuComRpcParam param);

    /**
     * 获取工厂信息列表
     *
     * @param param 查询条件
     * @return 工厂信息
     */
    @PostMapping("/findOuFactoryDto")
    List<OrgOuFactoryRpcDTO> findOuFactoryDtoByParam(@RequestBody OrgOuFactoryRpcDtoParam param);

    /**
     * 获取工厂详细信息列表-包括所属公司详细信息
     *
     * @param param 查询条件
     * @return 工厂和公司信息
     */
    @PostMapping("/findOuFactoryDetailDto")
    List<OrgOuFactoryDetailRpcDTO> findOuFactoryDetailDtoByParam(@RequestBody OrgOuFactoryRpcDtoParam param);

    @PostMapping("/findSimpleByOuCodes")
    List<OrgOuRpcSimpleDTO> findSimpleByOuCodes(@RequestBody List<String> ouCodes);

    /**
     * 根据公司id获取银行信息
     *
     * @param ouId
     * @return
     */
    @GetMapping("/findOuBank")
    List<OrgOuBankRpcDTO> findOuBank(@RequestParam("ouId") Long ouId);

    @GetMapping("/findIdsByOuCodeName")
    List<Long> findIdsByOuCodeName(@RequestParam("ouCodeName") String ouCodeName);

    @GetMapping("/findAllAppStoreSupplyOuRpcDto")
    List<OrgOuRpcSimpleDTO> findAllAppStoreSupplyOuRpcDto();
}
