package com.elitesland.support.provider.org.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel("公司DTO数据结构 仅包含部分数据")
public class OrgOuRpcSimpleDTO implements Serializable {

    private static final long serialVersionUID = 5952811508556472231L;

    @ApiModelProperty("公司ID")
    private Long id;

    @ApiModelProperty("纳税人类型，V：增值纳税人、S：小规模纳税人，E：不纳税")
    private String taxpayerType;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty(value = "公司类型，[UDC]yst-supp:OU_TYPE")
    private String ouType;

    @ApiModelProperty("组织ID")
    private Long buId;

    @ApiModelProperty("组织编码")
    private String buCode;

    @ApiModelProperty("组织名称")
    private String buName;

    @ApiModelProperty("是否启用工厂")
    private Boolean factoryEnableFlag;

    private Long addrNo;
}
