package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/3/25
 */
@Data
@ApiModel(value = "商品主表提供给供应链分页查询", description = "商品主表提供给供应链分页查询")
public class ItmItemSupplyPagingDTO implements Serializable {

    private static final long serialVersionUID = 2767870808708092018L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("品项id")
    private Long id;

    /**
     * 品项编号
     */
    @ApiModelProperty("品项编号")
    private String itemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    private String itemName;

    /**
     * 外部编号
     */
    @ApiModelProperty("外部编号")
    private String outerCode;

    /**
     * 条码
     */
    @ApiModelProperty("条码")
    private String barCode;

    /**
     * 定价计量单位
     */
    @ApiModelProperty("定价计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String pricingUom;
    private String pricingUomName;

    /**
     * 发运计量单位
     */
    @ApiModelProperty("发运计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String shipUom;
    private String shipUomName;

    /**
     * 默认采购单位
     */
    @ApiModelProperty("默认采购单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String purcUom;
    private String purcUomName;

    /**
     * 规格
     */
    @ApiModelProperty("规格")
    private String spec;

    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String brand;

    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    private String brandName;

    /**
     * 税率索引 进项
     */
    @ApiModelProperty("税率索引 进项")
    @SysCode(sys = "yst-supp", mod = "TAX_RATE_INDEX")
    String taxRateIndex;
    String taxRateIndexName;

    /**
     * 品项类型 [UDC]ITM:ITEM_TYPE
     */
    @ApiModelProperty("品项类型 [UDC]ITM:ITEM_TYPE")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE")
    String itemType;
    String itemTypeName;

    /**
     * 包装规格
     */
    @ApiModelProperty("包装规格")
    String packageSpec;

    /**
     * 存储方式 [UDC]ITM:STORE_MODE
     */
    @ApiModelProperty("存储方式 [UDC]ITM:STORE_MODE")
    @SysCode(sys = "yst-supp", mod = "STORE_MODE")
    String storeMode;
    String storeModeName;

    /**
     * 财务总账类别 [UDC]ITM:FIN_GL_TYPE
     */
    @ApiModelProperty("财务总账类别 [UDC]ITM:FIN_GL_TYPE")
    @SysCode(sys = "yst-supp", mod = "FIN_GL_TYPE")
    String finGlType;
    String finGlTypeName;

    /**
     * 大类编号 使用COM_C1表
     */
    @ApiModelProperty("大类编号 使用COM_C1表")
    String c1Code;

    /**
     * 中类编号 使用COM_C2表
     */
    @ApiModelProperty("中类编号 使用COM_C2表")
    String c2Code;

    /**
     * 商品分组 [UDC]yst-supp:ITEM_GROUP
     */
    @ApiModelProperty("商品分组 [UDC]yst-supp:ITEM_GROUP")
    @SysCode(sys = "yst-supp", mod = "ITEM_GROUP")
    String itemGroup;
    String itemGroupName;

    /**
     * 主计量单位
     */
    @ApiModelProperty("主计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    @ApiModelProperty("主计量单位名称")
    private String uomName;

    /**
     * 是否启用批次号
     */
    @ApiModelProperty("是否启用批次号")
    private Boolean lotFlag;

    /**
     * 效期管理标识
     */
    @ApiModelProperty("效期管理标识")
    private Boolean guaranteeFlag;

    /**
     * 保质期时长
     */
    @ApiModelProperty("保质期时长")
    private Integer guaranteePeriod;

    /**
     * 保质期单位 [UDC]COM:TIME_UNIT
     */
    @ApiModelProperty("保质期单位 [UDC]COM:TIME_UNIT")
    @SysCode(sys = "yst-supp", mod = "TIME_UNIT")
    private String guaranteePeriodUnit;
    private String guaranteePeriodUnitName;

    /**
     * 保质期天数
     */
    @ApiModelProperty("保质期天数")
    private Integer guaranteeDays;
}
