package com.elitesland.support.provider.org.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serial;
import java.io.Serializable;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/12 周五
 */
@Getter
@Setter
public class OrgRegionStoreDTO implements Serializable {
    @Serial
    private static final long serialVersionUID = -186905110106895900L;

    @ApiModelProperty(value = "区域编码", position = 2)
    private String regionCode;

    @ApiModelProperty(value = "区域名称", position = 3)
    private String regionName;

    @ApiModelProperty(value = "门店列表", position = 4)
    private List<RegionStoreDTO> storeList;

    @Getter
    @Setter
    public static class RegionStoreDTO implements Serializable {
        @Serial
        private static final long serialVersionUID = -4231862654888439843L;

        @ApiModelProperty(value = "门店id")
        private Long id;

        @ApiModelProperty(value = "门店编码")
        private String storeCode;

        @ApiModelProperty(value = "门店名称")
        private String storeName;
    }
}
