package com.elitesland.support.provider.org.param;

import com.elitesland.support.provider.org.RpcBaseModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;


/**
 * 功能说明 实体类:OrgStoreLicense
 *
 * @author meng
 * @date 2024-03-19 10:37:21
 */

@Data
@ApiModel("门店证件")
public class OrgStoreLicenseSaveRpcParam extends RpcBaseModel implements Serializable,DataHash {
private static final long serialVersionUID =1529198213519862979L;


    @ApiModelProperty(value = "主表id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;
	/**
	 * 证件编码
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "证件编码")
	private String licenseCode;

	/**
	 * 证件名称
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "证件名称")
	private String licenseName;

	@ApiModelProperty(value = "证件类型")
	private String licenseType;


	/**
	 * 经营范围
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "经营范围")
	private String businessScope;

	/**
	 * 有效日期从
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "有效日期从")
	@NotNull(message = "仓库有效期不能为空")
	private LocalDateTime startTime;

	/**
	 * 有效日期至
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "有效日期至")
	@NotNull(message = "仓库有效期不能为空")
	private LocalDateTime endTime;

	@ApiModelProperty(value = "颁发日期")

	private LocalDateTime issueDate;

	@ApiModelProperty(value = "统一社会信息代码")


	private String uniCertNo;

	@ApiModelProperty(value = "主体类型:0:个体工商户，1：企业")


	private Integer subjectType;


	@ApiModelProperty(value = "证照正面照片url")


	private String frontPicUrl;

	@ApiModelProperty(value = "证照反面照片url")


	private String backPicUrl;

	@ApiModelProperty(value = "证照图片url")


	private String picUrl;

	@ApiModelProperty(value = "经营项目")


	private String businessItems;

	@ApiModelProperty(value = "法定代表人")


	private String legalPerson;

	@ApiModelProperty(value = "经营场所")


	private String businessPlace;

	@ApiModelProperty(value = "地址")


	private String address;

	@ApiModelProperty(value = "证照正面照片文件编码")
	private String frontPicFileCode;

	@ApiModelProperty(value = "证照反面照片文件编码")
	private String backPicFileCode;

	@ApiModelProperty(value = "证照图片文件编码")
	private String picFileCode;

	@Override
	public Object[] waitHashContent() {
		return new Object[]{this.getId()};
	}
}
