package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/09/09
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "itemUomConvRpcDTO", description = "获取商品单位转换出参")
public class ItemUomConvRpcDTO implements Serializable {
    private static final long serialVersionUID = 288977485468083244L;

    /**
     * 商品id
     */
    @ApiModelProperty("商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    /**
     * 从单位
     */
    @ApiModelProperty("从单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String fromUom;

    /**
     * 从单位名称
     */
    @ApiModelProperty("从单位名称")
    private String fromUomName;

    /**
     * 到单位
     */
    @ApiModelProperty("到单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String toUom;

    /**
     * 到单位名称
     */
    @ApiModelProperty("到单位名称")
    private String toUomName;

    /**
     * 从数量
     */
    @ApiModelProperty("从数量")
    private BigDecimal fromConvertNum;

    /**
     * 到数量
     */
    @ApiModelProperty("到数量")
    private BigDecimal toConvertNum;

    /**
     * 转换系数
     */
    @ApiModelProperty(value = "转换系数")
    private BigDecimal ratio;
}
