package com.elitesland.support.provider.org.dto;

import com.elitescloud.boot.common.param.AreaVO;
import com.elitescloud.boot.common.param.CodeNameParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 区域信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/19
 */
@Getter
@Setter
@ApiModel(description = "区域信息")
public class OrgRegionDTO implements Serializable {
    private static final long serialVersionUID = -8761233022151204602L;

    @ApiModelProperty(value = "ID", position = 1)
    private Long id;

    @ApiModelProperty(value = "区域编码", position = 2)
    private String regionCode;

    @ApiModelProperty(value = "区域名称", position = 3)
    private String regionName;

    @ApiModelProperty(value = "适用对象，[UDC]yst-supp:REGION_USE_AT", position = 6)
    private String applicableObj;
    @ApiModelProperty(value = "适用对象名称", position = 5)
    private String applicableObjName;

    @ApiModelProperty(value = "适用属性，[UDC]yst-supp:STORE_TYPE2", position = 7)
    private List<CodeNameParam> applicableAttrList;

    @ApiModelProperty(value = "备用字段1", position = 11)
    private String bs1;

    @ApiModelProperty(value = "备用字段2", position = 12)
    private String bs2;

    @ApiModelProperty(value = "备用字段3", position = 13)
    private String bs3;

    @ApiModelProperty(value = "启用状态")
    private Boolean enabled;

    @ApiModelProperty("上级组织编码")
    private String parentOrgCode;

    @ApiModelProperty("上级组织名称")
    private String parentOrgName;

    @ApiModelProperty(value = "适用属性，[UDC]yst-supp:STORE_TYPE2", position = 7)
    private List<String> applicableAttrs;

    @ApiModelProperty( "适用属性名称")
    private List<CodeNameParam> applicableAttrNameList;

    @ApiModelProperty("匹配行政区域")
    private List<AreaVO> areaList;
}
