package com.elitesland.support.provider.item.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @author jeesie
 * @description: 商品供应商的配送区域VO
 * @datetime 2025年06月20日 16:14
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "ItmItemSuppRegionRpcDTO", description = "商品供应商的配送区域信息")
public class ItmItemSuppRegionRpcDTO {

    @ApiModelProperty("主表id")
    private Long masId;

    @ApiModelProperty("spuId")
    private Long spuId;

    @ApiModelProperty("spuCode")
    private String spuCode;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("供应商id")
    private Long suppId;

    @ApiModelProperty("是否配送全国")
    private Integer allArea;

    @ApiModelProperty("国家")
    private String country;

    @ApiModelProperty("国家名称")
    private String countryName;

    @ApiModelProperty("省份")
    private String province;

    @ApiModelProperty("省份名称")
    private String provinceName;

    @ApiModelProperty("城市")
    private String city;

    @ApiModelProperty("城市名称")
    private String cityName;

    @ApiModelProperty("区县")
    private String county;

    @ApiModelProperty("区县名称")
    private String countyName;
}
