package com.elitesland.support.provider.flexField.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
@Data
@ApiModel(value = "flexFieldStructDRpcDTO",description = "弹性域明细字段查询")
public class FlexFieldStructDRpcDTO implements Serializable {

    private static final long serialVersionUID = 1954152474773431737L;
    @ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty("冗余字段")
    private String flexField;

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("数据类型")
    private String dataType;

    @ApiModelProperty("来源类型")
    private String sourceType;

    @ApiModelProperty("值显示风格")
    private String valueStyle;

    @ApiModelProperty("udc-model")
    private String udcModel;

    @ApiModelProperty("udc-code")
    private String udcCode;

    @ApiModelProperty("udc-name")
    private String udcName;

    @ApiModelProperty("值集编码")
    private String flexibleCode;

    @ApiModelProperty("关联冗余字段")
    private String flexibleValueCode;

    @ApiModelProperty("来源弹性域")
    private String sourceFlexField;

    @ApiModelProperty("来源弹性域值")
    private String sourceFlexFieldValue;

    @ApiModelProperty("只读")
    private Boolean readOnly;

    @ApiModelProperty("显示")
    private Boolean display;

    @ApiModelProperty("是否查询条件")
    private Boolean queryCondition;

    @ApiModelProperty("启用")
    private Boolean enable;

    @ApiModelProperty("是否传递")
    private Boolean isTransmit;

    @ApiModelProperty("值传递字sql段条件")
    private String referSqlCondition;
}
