package com.elitesland.support.provider.item.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2025年 06月 21日 19:24
 * @version: 1.0
 */
@Data
public class ItmItemSuppRpcDTO implements Serializable {

    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("spuID")
    private Long spuId;

    @ApiModelProperty("商品ID")
    private String itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("masId")
    private Long itemSuppId;

    @ApiModelProperty("供应商配送区域")
    private List<ItmItemSuppRegionRpcDTO> suppRegionList;
}
