package com.elitesland.support.provider.org.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;


@Data
@ApiModel("门店表条件查询参数")
public class OrgStoreRpcParam extends AbstractOrderQueryParam {

    private static final long serialVersionUID = -3256161284093913271L;

    /**
     * 门店编号、名称
     */
    @ApiModelProperty(value = "门店编号、名称")
    private String storeCodeOrNameLike;

    /**
     * 门店类型
     */
    @ApiModelProperty(value = "门店类型")
    private String storeType;

    @ApiModelProperty(value = "门店编码集合")
    private List<String> storeCodes;

    /**
     * 所属上级组织ID
     */
    @ApiModelProperty(value = "所属上级组织ID")
    private Long pid;

    /**
     * 所属上级组织ID
     */
    @ApiModelProperty(value = "所属上级组织ID")
    private List<Long> pids;

    /**
     * 所属公司ID
     */
    @ApiModelProperty(value = "所属公司ID")
    private Long ouId;

    /**
     * 所属公司编码
     */
    @ApiModelProperty(value = "所属公司编码")
    private String ouCode;

    @ApiModelProperty(value = "所属公司编码")
    private List<String> ouCodes;

    /**
     * 经营性质
     */
    @ApiModelProperty(value = "经营性质")
    private String storeType2;

    /**
     * 店面等级
     */
    @ApiModelProperty(value = "店面等级")
    private String storeLevel;

    /**
     * 店面性质
     */
    @ApiModelProperty(value = "店面性质")
    private String storeType3;

    /**
     * 门店状态
     */
    @ApiModelProperty(value = "门店状态")
    private String storeStatus;

    @ApiModelProperty(value = "地址类型")
    private String addressType;

    private double lon;

    private double lat;

    @ApiModelProperty(value = "省份")
    private String province;

    @ApiModelProperty(value = "城市")
    private String city;

    @ApiModelProperty(value = "区县")
    private String county;

    @ApiModelProperty(value = "业务员id")
    private Long empId;

    @ApiModelProperty(value = "是否查询业务员")
    private Boolean withEmp;


    @ApiModelProperty(value = "门店负责人")
    private String storeManager;

    /**
     * 联系电话
     */
    @ApiModelProperty(value = "联系电话")
    private String storeContPhone;

    @ApiModelProperty(value = "渠道类型（线上，线下）")
    private String channelType;

    @ApiModelProperty(value = "客户编码")
    private String custCode;

    @ApiModelProperty(value = "ERP外部编码")
    private String outerCode;

    @ApiModelProperty(value = "商户号")
    private String merchantIdNum;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "区域负责人")
    private String regionRespPerson;

    @ApiModelProperty(value = "区域")
    private String region;

    @ApiModelProperty(value = "所属组织编码")
    private String pcode;

    @ApiModelProperty(value = "门店间数")
    private Long storeRoom;

    @ApiModelProperty(value = "店铺面积")
    private BigDecimal storeArea;

    @ApiModelProperty(value = "品牌id")
    private String brandId;

    @ApiModelProperty(value = "店铺介绍")
    private String storeIntrodu;

    @ApiModelProperty(value = "门店标签")
    private List<String> storeTags;

    @ApiModelProperty("建筑类型")
    private String buildingType;

    @ApiModelProperty("创建状态")
    private String createStatus;

    @ApiModelProperty(value = "GMV等级")
    private String gmvLevel;

    @ApiModelProperty(value = "储值公司ID")
    private Long storedOuId;
}
