package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.io.Serializable;

/**
 * 商品的财务评估类信息.
 *
 * @author Kaiser（wang shao）
 * @date 2025/7/22 周二
 */
@Getter
@Setter
@ApiModel(description = "商品的财务评估类信息")
public class ItmItemFinAssessmentDTO implements Serializable {
    private static final long serialVersionUID = 5888070760476964279L;

    @ApiModelProperty(value = "记录ID")
    private Long id;

    @ApiModelProperty(value = "公司ID")
    private Long ouId;

    @ApiModelProperty(value = "公司编码")
    private String ouCode;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;
    @ApiModelProperty(value = "商品名称")
    private String itemName;

    /**
     * 商品规格
     */
    @ApiModelProperty(value = "商品规格")
    private String spec;
    /**
     * 商品类别编码
     */
    @ApiModelProperty(value = "商品品类编码")
    private String itemCateCode;

    @ApiModelProperty(value = "SPU ID")
    private Long spuId;

    @ApiModelProperty(value = "SPU_CODE")
    private String spuCode;

    @ApiModelProperty(value = "财务评估类公司类型供应链公司")
    private String finAssessmentOuType1;

    @ApiModelProperty(value = "财务评估类公司类型非供应链公司")
    private String finAssessmentOuType2;

    @ApiModelProperty(value = "财务评估类公司类型门店")
    private String finAssessmentOuType3;

    @ApiModelProperty(value = "财务评估类值供应链公司")
    private String finAssessmentValue1;

    @ApiModelProperty(value = "财务评估类值非供应链公司")
    private String finAssessmentValue2;

    @ApiModelProperty(value = "财务评估类值门店")
    private String finAssessmentValue3;
}
