package com.elitesland.support.provider.flexField.service;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldAbstractVo;
import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import io.reactivex.rxjava3.functions.Function;

import java.util.List;
import java.util.Map;
public interface FlexFieldUtilService {
    /**
     * 处理值传递方法
     * @param flexFieldCode，弹性域编码
     * @param flexFieldWhereClauseMap，引用值查询sql条件映射，key:字段编码，value:用值查询sql的条件，如id=123
     * @param extensionInfo,待处理扩展信息，方法内部处理后，会将当前弹性域的引用值设置到该参数里
     * @return  内容和extensionInfo相同，包含了引用值
     */
    public Map<String,String> handFlexFieldValueFeference(String flexFieldCode, Map<String,String> flexFieldWhereClauseMap, Map<String,String> extensionInfo);
    /**
     * 处理值传递方法,重载，方法内部根据配置的引用值查询sql条件包含参数,将obj转map,将map的key和sql条件的参数进行匹配赋值，
     * 从而查询引用值,sql条件参数表示形式：@业务字段@，如id=@ou_id@
     * @param flexFieldCode，弹性域编码
     * @param obj，业务对象
     * @param extensionInfo，方法内部处理后，会将当前弹性域的引用值设置到该参数里
     * @return 内容和extensionInfo相同，包含了引用值
     */
    public Map<String,String> handFlexFieldValueFeference(String flexFieldCode,Object obj, Map<String,String> extensionInfo);

    public Map<String,String> handFlexFieldValueFeference(String flexFieldCode,Object obj);

    /**
     * 批量处理值传递字段
     * @param flexFieldCode
     * @param objs
     */
    public <T> void handFlexFieldValueFeferenceList(String flexFieldCode,List<T> objs);
    public void handleFlexFieldShowName(String flexFieldCode, List<? extends CustomFieldAbstractVo> records, Function<Object, Long> idGenerator);
    public void handleFlexFieldShowName(String flexFieldCode, List<? extends CustomFieldAbstractVo> records);
    public <T  extends CustomFieldAbstractVo> void handleSingleFlexFieldShowName(String flexFieldCode, T record);

    public <T extends CustomFieldBaseModelVo> void handleFlexFieldShowNameForVO(String flexFieldCode, List<T> records);
    public <T  extends CustomFieldBaseModelVo> void handleSingleFlexFieldShowNameForVO(String flexFieldCode, T record);
}
