package com.elitesland.support.provider.item.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/3/12
 */
@Data
@ApiModel(value = "商品品牌全部参数反参", description = "采购基础数据、采购价格、采购付款、供应商获取品牌信息反参")
public class ItmBrandAllDTO implements Serializable {

    private static final long serialVersionUID = 6207830507871135478L;
    @ApiModelProperty("记录唯一ID")
    private Long id;

    /**
     * 品牌编码
     */
    @ApiModelProperty(value = "品牌编码")
    private String brandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(value = "品牌名称")
    private String brandName;

    /**
     * 品牌英文名
     */
    @ApiModelProperty(value = "品牌英文名")
    private String brandEnName;

    /**
     * 品牌首字母
     */
    @ApiModelProperty(value = "品牌首字母")
    private String brandInitial;

    /**
     * 品牌代理商
     */
    @ApiModelProperty(value = "品牌代理商")
    private String brandAgent;

    /**
     * 品牌Logo
     */
    @ApiModelProperty(value = "品牌Logo")
    private String brandLogoUrl;

    /**
     * 品牌方
     */
    @ApiModelProperty(value = "品牌方")
    private String brandParty;

    /**
     * 品牌授权（0：否，1：是）
     */
    @ApiModelProperty(value = "品牌授权（0：否，1：是）")
    private Integer brandAuthorized;

    /**
     * 品牌授权开始时间
     */
    @ApiModelProperty(value = "品牌授权开始时间")
    private LocalDateTime brandAuthorizedStartTime;

    /**
     * 品牌授权结束时间
     */
    @ApiModelProperty(value = "品牌授权结束时间")
    private LocalDateTime brandAuthorizedEndTime;

    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private String status;

    /**
     * 租户ID
     */
    @ApiModelProperty(value = "租户ID")
    private Long tenantId;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    private Long createUserId = 0L;

    /**
     * 记录创建者
     */
    @ApiModelProperty("记录创建者")
    private String creator;

    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;

    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId;

    /**
     * 记录最后更新者
     */
    @ApiModelProperty("记录最后更新者")
    private String updater;

    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;

    /**
     * 逻辑删除，0：未删除，1：已删除
     */
    @ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;


    /**

     * 锁版本

     */

    @ApiModelProperty(value = "锁版本")
    private Integer auditDataVersion;
}
