package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/12/11
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "itmItemBomComRpcDTO", description = "商品BOM出参")
public class ItmItemBomComRpcDTO implements Serializable {
    private static final long serialVersionUID = 2924858643741866849L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty(value = "SKU商品编号")
    private String itemCode;

    @ApiModelProperty(value = "SKU商品名称")
    private String itemName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("适用组织id")
    private Long buId;

    @ApiModelProperty(value = "适用组织编码")
    private String buCode;

    @ApiModelProperty(value = "适用组织名称")
    private String buName;

    @ApiModelProperty(value = "商品规格")
    private String spec;

    @ApiModelProperty(value = "包装规格")
    private String packageSpec;

    @ApiModelProperty("品牌")
    private String brand;
    @ApiModelProperty("品牌名称")
    private String brandName;

    @ApiModelProperty(value = "数量(主计量单位的数量)")
    private BigDecimal qty;

    @ApiModelProperty(value = "损耗率")
    private BigDecimal lossRate;

    @ApiModelProperty(value = "权重")
    private BigDecimal weight;

    @ApiModelProperty("主计量单位 [UDC]COM:UOM")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty(value = "状态")
    @SysCode(sys = "yst-supp", mod = "COMMON_STATUS")
    private String bomStatus;
    @ApiModelProperty(value = "状态名称")
    private String bomStatusName;

    @ApiModelProperty(value = "品类编号")
    private String itemCateCode;

    @ApiModelProperty("品类(SPU)全路径名称")
    private List<String> itemCatePathName;

    @ApiModelProperty("品类(SPU)全称")
    private String itemCateFullName;

    @ApiModelProperty(value = "是否启用批次")
    private Boolean lotFlag;

    @ApiModelProperty(value = "保质期天数")
    private Integer guaranteeDays;

    @ApiModelProperty(value = "产品结构关系类型")
    @SysCode(sys = "yst-supp", mod = "STRU_RELA")
    private String productStruType;
    private String productStruTypeName;

    @ApiModelProperty(value = "产品结构关系编码")
    private Long productStruCode;

    @ApiModelProperty(value = "父ID")
    private Long pid;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("商品BOM ID")
    private Long id;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "商品BOM子件清单")
    private List<ItmItemBomComRpcDTO> itemBomDtlList;
}
