package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/08/16
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel("经营目录商品SKU组套商品DTO")
public class ItmItemBusinessRpcGroupDTO implements Serializable {
    private static final long serialVersionUID = 2979409083125177330L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("商品SKU Id")
    private Long itemId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("商品经营目录 Id")
    private Long businessId;

    /**
     * 商品SKU编号
     */
    @ApiModelProperty("商品SKU编号")
    private String itemCode;

    /**
     * 商品SKU名称
     */
    @ApiModelProperty("商品SKU名称")
    private String itemName;

    /**
     * 商品简称
     */
    @ApiModelProperty("商品简称")
    private String itemAbbr;

    /**
     * 外部编号
     */
    @ApiModelProperty("外部编号")
    private String outerCode;

    /**
     * 条码
     */
    @ApiModelProperty("条码")
    private String barCode;

    /**
     * 品类(SPU)编号
     */
    @ApiModelProperty("品类(SPU)编号")
    private String itemCateCode;

    /**
     * 品类(SPU)全路径名称
     */
    @ApiModelProperty("品类(SPU)全路径名称")
    private List<String> itemCatePathName;

    /**
     * 品类(SPU)全称
     */
    @ApiModelProperty("品类(SPU)全称")
    private String itemCateFullName;

    /**
     * 商品类型 [UDC]ITM:ITEM_TYPE
     */
    @ApiModelProperty("商品类型 [UDC]ITM:ITEM_TYPE")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE")
    private String itemType;
    private String itemTypeName;

    /**
     * 商品类型 [UDC]ITM:ITEM_TYPE2
     */
    @ApiModelProperty("商品类型 [UDC]ITM:ITEM_TYPE2")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE2")
    private String itemType2;
    private String itemType2Name;

    /**
     * 商品类型3 [UDC]ITM:ITEM_TYPE3
     */
    @ApiModelProperty("商品类型3 [UDC]ITM:ITEM_TYPE3")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE3")
    private String itemType3;
    private String itemType3Name;

    /**
     * 商品类型 [UDC]ITM:ITEM_STATUS
     */
    @ApiModelProperty("商品类型 [UDC]ITM:ITEM_STATUS")
    @SysCode(sys = "yst-supp", mod = "ITEM_STATUS")
    private String itemStatus;
    private String itemStatusName;

    /**
     * 规格
     */
    @ApiModelProperty("规格")
    private String spec;

    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String brand;

    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    private String brandName;

    /**
     * 包装规格
     */
    @ApiModelProperty("包装规格")
    String packageSpec;

    /**
     * 基本计量单位
     */
    @ApiModelProperty("基本计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    /**
     * 辅助计量单位
     */
    @ApiModelProperty("辅助计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom2;
    private String uom2Name;

    /**
     * 中包装计量单位
     */
    @ApiModelProperty("中包装计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom3;
    private String uom3Name;

    /**
     * 大包装计量单位
     */
    @ApiModelProperty("大包装计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom4;
    private String uom4Name;

    /**
     * 计量单位5
     */
    @ApiModelProperty("计量单位5")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom5;
    private String uom5Name;

    /**
     * 销售计量单位
     */
    @ApiModelProperty("销售计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String saleUom;
    private String saleUomName;

    /**
     * 采购计量单位
     */
    @ApiModelProperty("采购计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String purcUom;
    private String purcUomName;

    /**
     * 定价计量单位
     */
    @ApiModelProperty("定价计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String pricingUom;
    private String pricingUomName;

    /**
     * 发运计量单位
     */
    @ApiModelProperty("发运计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String shipUom;
    private String shipUomName;

    /**
     * 毛重
     */
    @ApiModelProperty("毛重")
    private BigDecimal grossWeight;

    /**
     * 净重
     */
    @ApiModelProperty("净重")
    private BigDecimal netWeight;

    @ApiModelProperty("净重单位 [UDC]yst-supp:WEIGHT_UNIT")
    @SysCode(sys = "yst-supp", mod = "WEIGHT_UNIT")
    private String netWeightUnit;
    private String netWeightUnitName;

    /**
     * 重量单位 [UDC]COM:WEIGHT_UNIT
     */
    @ApiModelProperty("重量单位 [UDC]COM:WEIGHT_UNIT")
    @SysCode(sys = "yst-supp", mod = "WEIGHT_UNIT")
    private String weightUnit;
    private String weightUnitName;

    /**
     * 体积
     */
    @ApiModelProperty("体积")
    private BigDecimal volume;

    /**
     * 体积单位 [UDC]COM:VOLUME_UNIT
     */
    @ApiModelProperty("体积单位 [UDC]COM:VOLUME_UNIT")
    @SysCode(sys = "yst-supp", mod = "VOLUME_UNIT")
    private String volumeUnit;
    private String volumeUnitName;

    /**
     * 配货类型 [UDC]ITM:ALLOC_TYPE
     */
    @ApiModelProperty("配货类型 [UDC]ITM:ALLOC_TYPE")
    @SysCode(sys = "yst-supp", mod = "ALLOC_TYPE")
    private String allocType;
    private String allocTypeName;

    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    /**
     * 供应商编号
     */
    @ApiModelProperty("供应商编号")
    private String suppCode;

    /**
     * 供应商名称
     */
    @ApiModelProperty("供应商名称")
    private String suppName;

    /**
     * 税码(进项)
     */
    @ApiModelProperty("税码(进项)")
    private String taxCode;

    /**
     * 税率(进项)，小于1的小数，保留8位，四舍五入
     */
    @ApiModelProperty("税率(进项)，小于1的小数，保留8位，四舍五入")
    private BigDecimal taxRate;

    /**
     * 税率描述(进项)
     */
    @ApiModelProperty("税率描述(进项)")
    private String taxRateDesc;

    /**
     * 税码2(销项)
     */
    @ApiModelProperty("税码2(销项)")
    private String taxCode2;

    /**
     * 税率2(销项)
     */
    @ApiModelProperty("税率2(销项)")
    private BigDecimal taxRate2;

    /**
     * 税率2描述(销项)
     */
    @ApiModelProperty("税率2描述(销项)")
    private String taxRate2Desc;

    /**
     * 关税税率
     */
    @ApiModelProperty("关税税率")
    private BigDecimal taxRateTariff;

    /**
     * 是否需要安装
     */
    @ApiModelProperty("是否需要安装")
    private Boolean installFlag;

    /**
     * 是否启用批次号
     */
    @ApiModelProperty("是否启用批次号")
    private Boolean lotFlag;

    /**
     * 效期管理标识
     */
    @ApiModelProperty("效期管理标识")
    private Boolean guaranteeFlag;

    /**
     * 保质期时长
     */
    @ApiModelProperty("保质期时长")
    private Integer guaranteePeriod;

    /**
     * 保质期单位 [UDC]COM:TIME_UNIT
     */
    @ApiModelProperty("保质期单位 [UDC]COM:TIME_UNIT")
    @SysCode(sys = "yst-supp", mod = "TIME_UNIT")
    private String guaranteePeriodUnit;
    private String guaranteePeriodUnitName;

    /**
     * 保质期天数
     */
    @ApiModelProperty("保质期天数")
    private Integer guaranteeDays;

    /**
     * 公司编码
     */
    @ApiModelProperty("公司编码")
    private String buCode;

    /**
     * 商品生命状态
     */
    @ApiModelProperty("商品生命状态")
    private String itemLifeStatus;


    /**
     * 数量(主计量单位的数量)
     */
    @ApiModelProperty(value = "数量(主计量单位的数量)")
    private BigDecimal qty;

    /**
     * 损耗率
     */
    @ApiModelProperty(value = "损耗率")
    private BigDecimal lossRate;

    @ApiModelProperty(value = "产品结构关系编码")
    private Long productStruCode;

    /**
     * 商品关系表头的SKU商品编号
     */
    @ApiModelProperty(value = "商品关系表头的SKU商品编号")
    private String productItemCode;

    /**
     * 商品关系表头的SKU商品名称
     */
    @ApiModelProperty(value = "商品关系表头的SKU商品名称")
    private String productItemName;
}
