package com.elitesland.support.provider.item.dto;

import com.elitesland.support.provider.item.TreeNodeRpc;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/03/21
 * @Version 1.0
 * @Content:
 */
@Data
public class ItmItemCateSimpleTreeRpcDTO implements TreeNodeRpc<ItmItemCateSimpleTreeRpcDTO> {

    private static final long serialVersionUID = 4985826626655616660L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("id")
    private Long id;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("pid")
    private Long pid;

    /**
     * 编号
     */
    @ApiModelProperty(value = "编号")
    private String code;

    /**
     * 路径
     */
    @ApiModelProperty(value = "路径")
    private String path;

    /**
     * 排序序号
     */
    @ApiModelProperty(value = "排序序号")
    private Integer sortNo;

    /**
     * 级别
     */
    @ApiModelProperty(value = "级别")
    private Integer level;

    /**
     * 树形结构中，是否是末尾节点
     */
    @ApiModelProperty(value = "是否末尾节点")
    private Boolean isLeaf;

    /**
     * 子节点
     */
    @ApiModelProperty(value = "子节点")
    private List<ItmItemCateSimpleTreeRpcDTO> treeNodes;

    /**
     * 商品品类编码
     */
    @ApiModelProperty(value = "商品品类编码")
    private String itemCateCode;

    /**
     * 商品品类名称
     */
    @ApiModelProperty(value = "商品品类名称")
    private String itemCateName;
}
