package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "ThaliItemDetailNewRpcDTO", description = "规格组子件全数据出参")
public class ThaliItemDetailNewRpcDTO implements Serializable {

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("ID")
    private Long id;

    @ApiModelProperty("菜品ID")
    private Long masId;

    @ApiModelProperty("规格组ID")
    private Long sizeGroupId;
    @ApiModelProperty("规格组编号")
    private String sizeGroupCode;
    @ApiModelProperty("规格组名称")
    private String sizeGroupName;

    @ApiModelProperty("规格值ID")
    private Long sizeId;
    @ApiModelProperty("规格值编码")
    private String sizeCode;
    @ApiModelProperty("规格值名称")
    private String sizeName;


    @ApiModelProperty("SPU子件编码")
    private String itemCode;
    @ApiModelProperty("SPU子件名称")
    private String itemName;

    @ApiModelProperty("子件类型")
    private String itemType;
    private String itemTypeName;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("半成品耗用方式")
    @SysCode(sys = "yst-supp", mod = "SEMI_USAGE_TYPE")
    private String semiProdConsMode;
    private String semiProdConsModeName;

    @ApiModelProperty(value = "出成率")
    private BigDecimal yield;

    @ApiModelProperty("替换商品集合")
    private List<ThaliItemNewDtlReplaceRpcDTO> replaceList;

    @ApiModelProperty("分量")
    private String sizeWeight;

    @ApiModelProperty("分量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String sizeWeightUom;
    private String sizeWeightUomName;

    @ApiModelProperty("领用单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String receiveUom;
    private String receiveUomName;

    @ApiModelProperty(value = "领用单位转换系数")
    private BigDecimal receiveUomRatio;

    @ApiModelProperty("加工方式")
    private String processMode;

    @ApiModelProperty("出成数量")
    private Integer outputQty;

}
