package com.elitesland.support.provider.item.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/09/09
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "itemUomConvRpcParam", description = "获取商品单位转换入参")
public class ItemUomConvRpcParam implements Serializable {
    private static final long serialVersionUID = 7874297850752726946L;

    /**
     * 商品id
     */
    @NotNull(message = "商品id不能为空")
    @ApiModelProperty("商品id")
    private Long itemId;

    /**
     * 从单位
     */
    @NotNull(message = "从单位不能为空")
    @ApiModelProperty("从单位")
    private String fromUom;

    /**
     * 到单位
     */
    @ApiModelProperty("到单位")
    private String toUom;

    /**
     * 从数量
     */
    @NotNull(message = "从数量不能为空")
    @ApiModelProperty("从数量数量")
    private BigDecimal fromConvertNum;

}
