package com.elitesland.support.provider.item.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/11/24
 * @Version 1.0
 * @Content:
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "itmItemBaseRpcParam", description = "商品基础信息查询参数")
public class ItmItemBaseRpcParam implements Serializable {
    private static final long serialVersionUID = 6398059004861201351L;

    /**
     * 商品SKU的ID集合
     */
    @ApiModelProperty("商品SKU的ID集合")
    private List<Long> itemIds;

    /**
     * 商品SKU的编码集合
     */
    @ApiModelProperty("商品SKU的编码集合")
    private List<String> itemCodes;

    /**
     * 商品SKU状态
     */
    @ApiModelProperty(value = "商品SKU状态")
    private List<String> itemStatus2List;
}
