package com.elitesland.support.provider.item.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author Chris
 * @date 2021-05-24
 */
@Data
@ApiModel("商品BOM分页查询条件")
public class ItmItemBomRpcParam implements Serializable {



    /**
     * 商品SKU编码
     */
    @ApiModelProperty(value = "商品SKU编码")
    private List<Long> itemId;

    /**
     * 适用组织
     */
    @ApiModelProperty(value = "适用组织")
    private Long buId;


    /**
     * 计量单位
     */
    @ApiModelProperty("计量单位")
    private String uom;


    /**
     * 商品SKU编码
     */
    @ApiModelProperty(value = "商品SKU编码")
    private List<String> itemCode;

    /**
     * erp商品，支持模糊查询
     */
    @ApiModelProperty(value = "erp商品，支持模糊查询")
    private String erpItem;

    /**
     * 产品结构关系类型
     */
    @ApiModelProperty(value = "产品结构关系类型")
    private String productStruType;

    /**
     * 产品结构关系编码
     */
    @ApiModelProperty(value = "产品结构关系编码")
    private Long productStruCode;

    /**
     * 父ID, 默认为0
     */
    @ApiModelProperty(value = "父ID, 默认为0")
    private Long pid = 0L;
}
