package com.elitesland.support.provider.item.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author Chris
 * @date 2021-04-12
 */
@Data
public class ItmItemSkuSaveRpcParam implements Serializable {

    private static final long serialVersionUID = -5067952387649966520L;

    /**
     * 记录唯一ID
     */
    @ApiModelProperty(value = "记录唯一ID")
    private Long id;

    /**
     * 商品规格(JSON格式)
     */
    @ApiModelProperty(value = "商品规格(JSON格式)")
    private String itemAttr;

    /**
     * SKU商品编号
     */
    @ApiModelProperty(value = "SKU商品编号")
    private String itemCode;

    /**
     * SKU商品编号2
     */
    @ApiModelProperty(value = "SKU商品编号2")
    private String itemCode2;

    /**
     * SKU商品名称
     */
    @ApiModelProperty(value = "SKU商品名称")
    private String itemName;

    /**
     * SKU商品简称
     */
    @ApiModelProperty(value = "SKU商品简称")
    private String itemAbbr;

    /**
     * 条码
     */
    @ApiModelProperty(value = "条码")
    private String barCode;

    /**
     * 外部编号
     */
    @ApiModelProperty(value = "外部编号")
    private String outerCode;

    /**
     * 供应商物料编码
     */
    @ApiModelProperty(value = "供应商物料编码")
    private String suppItemCode;

    // ********************************* 商品图片 *********************************

    /**
     * SKU 图片编号
     */
    @ApiModelProperty(value = "SKU 图片")
    List<ItmItemAttachmentSaveRpcParam> skuImages;


    // **************************************************************************************
    // ********************************* 价格相关字段 *********************************

    /**
     * 市场价
     */
    @ApiModelProperty(value = "市场价")
    private BigDecimal price1;

    /**
     * B端指导价
     */
    @ApiModelProperty(value = "B端指导价")
    private BigDecimal price2;

    /**
     * C端零售价
     */
    @ApiModelProperty(value = "C端零售价")
    private BigDecimal price3;

    /**
     * B端毛利控制率
     */
    @ApiModelProperty(value = "B端毛利控制率")
    private BigDecimal price4;

    /**
     * C端毛利控制率
     */
    @ApiModelProperty(value = "C端毛利控制率")
    private BigDecimal price5;

    /**
     * B端毛利率
     */
    @ApiModelProperty(value = "B端毛利率")
    private BigDecimal price6;

    /**
     * C端毛利率
     */
    @ApiModelProperty(value = "C端毛利率")
    private BigDecimal price7;

    /**
     * 采购价
     */
    @ApiModelProperty(value = "采购价")
    private BigDecimal price8;

    /**
     * 商品识别号(组织编号)对应公司的币种
     */
    @ApiModelProperty(value = "商品识别号(组织编号)对应公司的币种")
    private String currCode;

    // **************************************************************************************

    /**
     * 基本计量单位
     */
    @ApiModelProperty("基本计量单位 [UDC]yst-supp:UOM")
    private String uom;

    /**
     * 辅助计量单位
     */
    @ApiModelProperty("辅助计量单位 [UDC]yst-supp:UOM")
    private String uom2;

    /**
     * 中包装计量单位
     */
    @ApiModelProperty("中包装计量单位 [UDC]yst-supp:UOM")
    private String uom3;

    /**
     * 大包装计量单位
     */
    @ApiModelProperty("大包装计量单位 [UDC]yst-supp:UOM")
    private String uom4;

    /**
     * 计量单位5
     */
    @ApiModelProperty("计量单位5 [UDC]yst-supp:UOM")
    private String uom5;

    /**
     * 销售计量单位
     */
    @ApiModelProperty("销售计量单位 [UDC]yst-supp:UOM")
    private String saleUom;

    /**
     * 采购计量单位
     */
    @ApiModelProperty("采购计量单位 [UDC]yst-supp:UOM")
    private String purcUom;

    /**
     * 定价计量单位
     */
    @ApiModelProperty("定价计量单位 [UDC]yst-supp:UOM")
    private String pricingUom;

    /**
     * 发运计量单位
     */
    @ApiModelProperty("发运计量单位 [UDC]yst-supp:UOM")
    private String shipUom;

    /**
     * 要货计量单位
     */
    @ApiModelProperty("要货计量单位 [UDC]yst-supp:UOM")
    private String orderUom;


    /**
     * 包装规格
     */
    @ApiModelProperty(value = "包装规格")
    private String packageSpec;

    /**
     * 毛重
     */
    @ApiModelProperty(value = "毛重")
    private BigDecimal grossWeight;

    /**
     * 净重
     */
    @ApiModelProperty(value = "净重")
    private BigDecimal netWeight;

    @ApiModelProperty("净重单位 [UDC]yst-supp:WEIGHT_UNIT")
    private String netWeightUnit;

    /**
     * 重量单位 [UDC]COM:WEIGHT_UNIT
     */
    @ApiModelProperty(value = "重量单位 [UDC]COM:WEIGHT_UNIT")
    private String weightUnit;

    /**
     * 体积
     */
    @ApiModelProperty(value = "体积")
    private BigDecimal volume;

    /**
     * 体积单位 [UDC]COM:VOLUME_UNIT
     */
    @ApiModelProperty(value = "体积单位 [UDC]COM:VOLUME_UNIT")
    private String volumeUnit;

    /**
     * 长
     */
    @ApiModelProperty(value = "长")
    private BigDecimal length;

    /**
     * 宽
     */
    @ApiModelProperty(value = "宽")
    private BigDecimal width;

    /**
     * 高
     */
    @ApiModelProperty(value = "高")
    private BigDecimal height;

    /**
     * 尺寸单位 [UDC]yst-supp:LENGTH_UNIT
     */
    @ApiModelProperty(value = "尺寸单位 [UDC]yst-supp:LENGTH_UNIT")
    private String lengthUnit;





    /**
     * 商品状态2
     */
    @ApiModelProperty(value = "商品状态2")
    private String itemStatus2;

    /**
     * SKU商品标签
     */
    @ApiModelProperty(value = "SKU商品标签")
    private List<ItmItemTagSaveRpcParam> itemSaveTags;

    /**
     * SKU单位转换系数
     */
//    @ApiModelProperty(value = "SKU单位转换系数")
//    private List<ItmItemUomConvSaveRpcParam> itemUomConvSaveParams;
}
