package com.elitesland.support.provider.item.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author : Scott.zhang(zhang hang)
 * @Date : 2021/12/2116:46
 */
@Data
public class ItmItemUomRpcVO implements Serializable {
    private static final long serialVersionUID = 4295223679065290245L;

    /**
     * 商品id
     */
    @ApiModelProperty("商品id")
    private Long id;

    /**
     * 主计量单位
     */
    @ApiModelProperty("主计量单位")
    private String uom;

    /**
     * 商品编码
     */
    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    /**
     * 商品名称
     */
    @ApiModelProperty("商品名称")
    private String itemName;

    /**
     * 删除标志
     */
    @ApiModelProperty("删除标志")
    private Integer deleteFlag;

    /**
     * 标准供应价
     */
    @ApiModelProperty(value = "标准供应价")
    private BigDecimal price;

    /**
     * 采购含税价
     */
    @ApiModelProperty(value = "采购含税价")
    private BigDecimal price8;

    /**
     * 销售含税价
     */
    @ApiModelProperty(value = "销售含税价")
    private BigDecimal price9;

    /**
     * 税率编号(进项)
     */
    @ApiModelProperty(value = "税率编号(进项)")
    private String taxRateNo;

    /**
     * 税率编号2(销项)
     */
    @ApiModelProperty(value = "税率编号2(销项)")
    private String taxRateNo2;
}
