package com.elitesland.support.provider.org;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
@Data
public class RpcBaseModel {
    @ApiModelProperty("记录唯一ID")
    @JsonSerialize(
            using = ToStringSerializer.class
    )
    private Long id;
    @ApiModelProperty("租户ID")
    private Long tenantId;
    @ApiModelProperty("备注")
    private String remark;
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;
    @ApiModelProperty("记录创建者")
    private String creator;
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId = 0L;
    @ApiModelProperty("记录最后更新者")
    private String updater;
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag = 0;
    @ApiModelProperty("锁版本")
    private Integer auditDataVersion;
    @ApiModelProperty("操作类型:CREATE,UPDATE,NONE")
    private String operType;
}
