package com.elitesland.support.provider.org.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/10/10
 * @Version 1.0
 * @Content:
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "orgUserInfoRpcDtoParam", description = "查询用户的员工、公司、组织信息入参")
public class OrgUserInfoRpcDtoParam implements Serializable {
    private static final long serialVersionUID = -372833810133422295L;

    /**
     * 用户ID
     */
    @ApiModelProperty("用户ID")
    @NotNull(message = "用户ID不能为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long userId;

    /**
     * 登录账号
     */
    @ApiModelProperty("登录账号")
    private String username;

    /**
     * 手机号码
     */
    @ApiModelProperty("手机号码")
    private String mobile;

    /**
     * 组织ID
     */
    @ApiModelProperty("组织ID")
    @NotNull(message = "组织ID不能为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long orgId;
}
