package com.elitesland.support.provider.org.service;

import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.org.dto.OrgEmpRpcDTO;
import com.elitesland.support.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.support.provider.org.param.OrgEmpRpcDtoParam;
import com.elitesland.support.provider.org.param.OrgEmpUserRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author Chris
 * @date 2021-04-28
 */
@FeignClient(name = Application.NAME, path = Application.PATH + OrgEmpRpcService.PATH)
@Validated
public interface OrgEmpRpcService {
    String PATH = "/orgEmpRpc";
    /**
     * 获取员工信息列表，该接口一般应用与如下场景
     * 1. 第三方通过id或者code获取一些基本信息，用于后端处理
     * 2. 检查数据是否存在，存在则会返回数据，不存在则不会返回数据
     *
     * 如果传入的查询参数均为空，则不返回任何数据，防止获取全部数据
     *
     * 注意接口返回数据没有上限控制，请合理使用，保证效能
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 查询条件，每个条件使用 and 关联
     * @return dto
     */
    @PostMapping("/findEmpDto")
    List<OrgEmpRpcDTO> findEmpDtoByParam(@RequestBody OrgEmpRpcDtoParam param);

    /**
     * 根据用户ID获取当前用户员工信息
     * 包含员工所属组织，所属公司，以及默认联系方式
     *
     * 如果返回的结果是 null，则说明当前用户并未绑定员工
     *
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param userId 用户ID
     * @return 员工相关信息
     */
    @GetMapping("/findUserEmpInfo")
    OrgUserEmpInfoRpcDTO findUserEmpInfo(@RequestParam("userId") Long userId);

    /**
     * 用户导入 绑定员工接口
     *
     * 返回信息：当前员工已经被其他用户绑定
     *
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param 保存参数
     * @return 错误信息
     */
    @PostMapping("/userExportBindEmp")
    String userExportBindEmp(@RequestBody List<OrgEmpUserRpcParam> param);
}
