package com.elitesland.support.provider.out;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class WmsResult implements Serializable {
    private boolean success; // 是否推送成功
    private String outSysKey;
    @ApiModelProperty(value = "外部系统skuId")
    private String outSysSkuId;
    private String status;
    private String log; // 失败日志
    private ItmItemSendParam payload;
    // 撤回无需上传 则删除商品上传表
    private boolean revert;

    public static WmsResult success() {
        WmsResult wmsResult = new WmsResult();
        wmsResult.success = true;
        return wmsResult;
    }

    public static WmsResult fail(String error) {
        WmsResult wmsResult = new WmsResult();
        wmsResult.success = false;
        wmsResult.log = error;
        return wmsResult;
    }

    public static WmsResult success(String info) {
        WmsResult wmsResult = new WmsResult();
        wmsResult.success = true;
        wmsResult.log = info;
        return wmsResult;
    }
}
