package com.elitesland.support.provider.path.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/3/10
 */
@Data
@ApiModel("结算路径查询参数")
public class SupportTransactionPathRpcParam implements Serializable {

    private static final long serialVersionUID = -60151055238354033L;

    @ApiModelProperty(value = "'路径编码")
    private String pathCode;

    @ApiModelProperty(value = "路径名称")
    private String pathName;

    @ApiModelProperty(value = "从公司id")
    private Long companyIdStart;

    @ApiModelProperty(value = "至公司id")
    private Long companyIdEnd;

    @ApiModelProperty(value = "从公司编码")
    private String companyCodeStart;

    @ApiModelProperty(value = "至公司编码")
    private String companyCodeEnd;

    @ApiModelProperty(value = "从公司名称")
    private String companyNameStart;

    @ApiModelProperty(value = "至公司名称")
    private String companyNameEnd;

    @ApiModelProperty(value = "有效期从")
    private LocalDateTime validFrom;

    @ApiModelProperty(value = "有效期至")
    private LocalDateTime validTo;

    @ApiModelProperty(value = "状态")
    private String pathStatus;

    @ApiModelProperty(value = "有效期 默认当前时间")
    private LocalDateTime effectiveTime;

}
