package com.elitesland.support.provider.price.service;


import com.elitesland.support.provider.org.service.OrgBuRpcService;
import com.elitesland.support.provider.price.param.PriMainPriceRpcDtoParam;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.price.dto.PriMainPriceRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author Chris
 * @date 2021-06-13
 */
@FeignClient(name = Application.NAME, path = Application.PATH + OrgBuRpcService.PATH)
@Validated
public interface PriMainPriceRpcService {
    String PATH = "/priMainPriceRpc";

    /**
     * 获取商品价格信息列表，该接口一般应用与如下场景
     * 第三方通过查询获取一些基本信息，用于后端处理
     *
     * 注意如果不指定价格生效区间的话，则默认取当前时间生效的数据
     * 如果参数中，itemIds和itemCodes都为空，则不返回任何数据，防止获取大批量数据
     *
     * 注意接口的时间查询参数分为两种类型：时间点，时间区间
     * 如果与时间有关的查询都没有传，则默认当前时间为生效时间点，获取数据
     * 如果传了时间点，则时间区间查询参数将会被忽略
     * 时间点：价格生效期间包含时间点的价格会被查出来
     * 时间区间：数据库中validTo大于等于查询参数validFrom，数据库中的validFrom小于等于查询参数的validTo，
     * 可以单独传时间区间的其中一个参数，表示大于等于，或小于等于，或二者皆有，即上述两个条件的任意组合
     *
     * 注意接口返回数据没有上限控制，请合理使用，保证效能
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 查询条件，每个条件使用 and 关联
     * @return dto
     */
    @GetMapping("/findMainPriceRpcDto")
    List<PriMainPriceRpcDTO> findMainPriceRpcDtoByParam(@RequestBody PriMainPriceRpcDtoParam param);
}
