package com.elitesland.support.provider.item;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/03/21
 * @Version 1.0
 * @Content:
 */
public interface TreeNodeRpc<T extends TreeNodeRpc<T>> extends Comparable<TreeNodeRpc<T>>, Serializable {

    /**
     * 获取ID
     * @return ID
     */
    Long getId();

    /**
     * 获取排序序号
     * @return 排序序号
     */
    Integer getSortNo();

    /**
     * 获取父ID
     * @return 父ID
     */
    Long getPid();

    /**
     * 设置pif
     * @param pid
     */
    void setPid(Long pid);

    /**
     * 设置排序号
     * @param sortNo
     */
    void setSortNo(Integer sortNo);

    /**
     * 设置是否是最后一级
     * @param isLeaf isLeaf
     */
    void setIsLeaf(Boolean isLeaf);

    /**
     * 获取子树
     * @return 子树
     */
    List<T> getTreeNodes();

    /**
     * 设置子树
     * @param treeNodes 子树
     */
    void setTreeNodes(List<T> treeNodes);



    /**
     * 排序
     * @param o 目标
     * @return 排序大小
     */
    @Override
    default int compareTo(TreeNodeRpc o) {
        return (this.getSortNo() == null ? 0 : this.getSortNo()) - (o.getSortNo() == null ? 0 : o.getSortNo());
    }

}
