package com.elitesland.support.provider.org.param;

import com.elitesland.support.provider.org.RpcBaseModel;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 加盟商新增/修改参数
 * @author Rikyon
 * @date 2025/8/21
 */
@Data
@ApiModel("加盟商新增/修改参数")
public class OrgFranchiseeDtoParam extends RpcBaseModel implements Serializable,DataHash {

    private static final long serialVersionUID = 4958634832113727873L;

    @ApiModelProperty("操作类别")
    private String operType;

    @ApiModelProperty("加盟商代码")
    private String franchiseeCode;

    @ApiModelProperty("加盟商名称")
    private String franchiseeName;

    @ApiModelProperty("加盟商证件号")
    private String franchiseeDocNo;

    @ApiModelProperty("加盟商联系电话")
    private String franchiseePhone;

    @ApiModelProperty("加盟商状态")
    private String franchiseeStatus;

    @ApiModelProperty("加盟时间")
    private LocalDateTime joinTime;

    @ApiModelProperty("实体类型")
    private String entityType;

    @ApiModelProperty("基本信息")
    private BasicInfo basicInfo;

    @ApiModelProperty("身份证照片")
    private IdCardPhotos idCardPhotos;

    @ApiModelProperty("个人相关信息")
    private IndividualInfo individualInfo;

    @ApiModelProperty("企业相关信息")
    private EnterpriseInfo enterpriseInfo;

    @ApiModelProperty("业绩指标")
    private PerformanceMetrics performanceMetrics;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("数据源")
    private String dataSource;

    @Data
    public static class BasicInfo implements Serializable {
        @ApiModelProperty("姓名")
        private String name;

        @ApiModelProperty("性别")
        private String gender;

        @ApiModelProperty("出生日期")
        private LocalDateTime birthDate;

        @ApiModelProperty("籍贯")
        private String origin;

        @ApiModelProperty("身份证号码")
        private String idNumber;

        @ApiModelProperty("电子邮箱")
        private String email;
    }

    @Data
    public static class IdCardPhotos implements Serializable {
        @ApiModelProperty("身份证人像面照片URL")
        private String portraitSide;

        @ApiModelProperty("身份证国徽面照片URL")
        private String nationalEmblemSide;
    }

    @Data
    public static class IndividualInfo implements Serializable {
        @ApiModelProperty("签署人姓名")
        private String signatoryName;

        @ApiModelProperty("签署人证件类型")
        private String signatoryDocType;

        @ApiModelProperty("签署人证件号")
        private String signatoryDocNumber;

        @ApiModelProperty("签署人电话")
        private String signatoryPhone;
    }

    @Data
    public static class EnterpriseInfo implements Serializable {
        @ApiModelProperty("公司名称")
        private String companyName;

        @ApiModelProperty("统一社会信用代码")
        private String creditCode;

        @ApiModelProperty("法定代表人姓名")
        private String legalPersonName;

        @ApiModelProperty("法定代表人证件类型")
        private String legalPersonDocType;

        @ApiModelProperty("法定代表人身份类型")
        private String legalPersonIdentity;

        @ApiModelProperty("法定代表人证件号")
        private String legalPersonDocNumber;

        @ApiModelProperty("法定代表人手机号")
        private String legalPersonMobile;

        @ApiModelProperty("注册资本")
        private Integer registeredCapital;

        @ApiModelProperty("成立日期")
        private LocalDateTime establishmentDate;

        @ApiModelProperty("营业执照照片URL")
        private String businessLicensePhoto;
    }

    @Data
    public static class PerformanceMetrics implements Serializable {
        @ApiModelProperty("总积分")
        private Integer totalPoints;

        @ApiModelProperty("等级")
        private String level;

        @ApiModelProperty("门店数量")
        private Integer storeCount;

        @ApiModelProperty("终止数量")
        private Integer terminatedCount;
    }
    @Override
    public Object[] waitHashContent() {
        return new Object[]{this.franchiseeCode,franchiseeName};
    }

}
