package com.elitesland.support.provider.org.param;

import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * ClassName: OrgStoreInvoiceInfoParam
 * Description:
 *
 * @author wz
 * @date 2025/7/12 16:19
 */
@Data
@ApiModel("发票信息新增参数")
public class OrgStoreInvoiceInfoParam implements Serializable {


    @ApiModelProperty(value = "发票类型", required = true)
    private String invoiceType;

    @ApiModelProperty(value = "开票抬头", required = true)
    private String invoiceTitle;

    @ApiModelProperty(value = "税号", required = true)
    private String taxNumber;

    @ApiModelProperty(value = "开票地址", required = true)
    private String invoiceAddress;

    @ApiModelProperty(value = "开票电话", required = true)
    private String invoicePhone;

    @ApiModelProperty(value = "开户银行", required = true)
    private String bankName;

    @ApiModelProperty(value = "银行账号", required = true)
    private String bankAccount;

    @ApiModelProperty(value = "开票联系人", required = true)
    private String contactPerson;

    @ApiModelProperty(value = "联系人电话", required = true)
    private String contactPhone;

    @ApiModelProperty(value = "开票邮箱")
    private String invEmail;

}
