package com.elitesland.support.provider.franchisees.param;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@Data
@ApiModel(value = "加盟商信息")
public class CrmFranchiseesRpcSaveParam extends BaseViewModel {

    @ApiModelProperty("加盟身份 1个人加盟 2企业加盟")

    private Boolean joinType;

    @ApiModelProperty("身份证号码")

    private String idCardNo;

    @ApiModelProperty("身份证正面")

    private String frontOfIdCard;

    @ApiModelProperty("身份证正面")

    private String backOfIdCard;

    @ApiModelProperty("1-未婚 2-已婚 3-离婚 4-丧偶")

    private Boolean maritalStatus;

    @ApiModelProperty("1-初中及以下 2-高中 3-专科 4-本科及以上")

    private Boolean educationLevel;

    @ApiModelProperty("户口地址")

    private String householdRegistrationAddress;


    @ApiModelProperty("结算卡卡号")

    private String settlementCardNo;


    @ApiModelProperty("结算卡开户行")

    private String settlementOpeningBank;

    @ApiModelProperty("结算卡照片")

    private String settlementCardPic;

    @ApiModelProperty("创业经历 0-无 1-有")

    private Boolean entrepreneurialExperience;

    @ApiModelProperty("以往从事行业")

    private String previouslyEngagedIndustries;

    @ApiModelProperty("银行流水图片")

    private String bankStatementsPic;


    @ApiModelProperty("曾经经营过的品牌")

    private String oldBrands;


    @ApiModelProperty("目前经营的品牌")

    private String newBrands;


    @ApiModelProperty("公司名称")

    private String enterpriseName;


    @ApiModelProperty("注册地址")

    private String companyRegisteredAddress;


    @ApiModelProperty("办公地址")

    private String officeAddress;


    @ApiModelProperty("法人姓名")

    private String legalName;


    @ApiModelProperty("法人身份证号码")

    private String legalIdCardNo;


    @ApiModelProperty("身份证正面")

    private String legalIdCardFront;


    @ApiModelProperty("身份证正面")

    private String legalIdCardBack;


    @ApiModelProperty("业务负责人姓名")

    private String businessLeaderName;


    @ApiModelProperty("业务负责人联系方式")

    private String businessLeaderMobile;


    @ApiModelProperty("业务负责人姓名")

    private String financialManagerName;


    @ApiModelProperty("业务负责人联系方式")

    private String financialManagerMobile;


    @ApiModelProperty("第三方创建时间")

    private LocalDateTime outerCreateTime;


    @ApiModelProperty("第三方更新时间")

    private LocalDateTime outerUpdateTime;


    @ApiModelProperty("营业执照图片")

    private String businessLicense;

    @ApiModelProperty("统一社会信用代码")

    private String unifiedSocialCreditCode;

    @ApiModelProperty("第三方ID")

    private Long outerId;

    @ApiModelProperty("第三方code")

    private String outerCode;

    //后加8个字段
    //join_status	加盟商状态		tinyint(1)	0-线索 1-准加盟商 2-加盟商

    @ApiModelProperty("0-线索 1-准加盟商 2-加盟商")

    private Boolean joinStatus;

    //user_channel_id	来源		bigint(20)
    @ApiModelProperty("来源")

    private Long userChannelId;

    //user_portrait	标签		varchar(64)
    @ApiModelProperty("标签")

    private String userPortrait;
    //mobile	加盟商手机号码		varchar(64)
    @ApiModelProperty("加盟商手机号码")

    private String mobile;

    //live_address	现居住地		varchar(255)
    @ApiModelProperty("现居住地")

    private String liveAddress;

    //contact_name	联系人姓名		varchar(64)
    @ApiModelProperty("联系人姓名")

    private String contactName;

    //contact_mobile	联系人手机号码		varchar(64)
    @ApiModelProperty("联系人手机号码")

    private String contactMobile;

    //contact_address	联系地址
    @ApiModelProperty("联系地址")

    private String contactAddress;
}