package com.elitesland.support.provider.sys.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.sys.dto.SysUnitMappingRpcDTO;
import com.elitesland.support.provider.sys.param.SysUnitMappingQuaryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * 外部系统单位映射，该模块主要用于检验！
 * @Author Rikyon
 * @Date 2025/9/2 9:55
 */

@FeignClient(name = Application.NAME, path = Application.PATH + SysUnitMappingRpcService.PATH)
@Validated
public interface SysUnitMappingRpcService {
    String PATH = "/sysUnitMappingRpc";

    /**
     * 根据系统编码和单位编码获取中台单位编码
     * @param param
     * @return fail表示没查到
     */
    @PostMapping("/getUnit")
    ApiResult<String> getUnitBySysCodeAndUnitCode(@RequestBody SysUnitMappingQuaryParam param);

    /**
     * 根据系统编码和单位编码获取中台单位编码
     * @param param
     * @return 键是外部系统code+‘-’+单位编码，值是中台单位编码
     */
    @PostMapping("/getUnitMapByCode")
    ApiResult<Map<String, String>> getSysUnitByUnitCode(@RequestBody List<SysUnitMappingQuaryParam> param);

    /**
     * 根据系统编码和单位名称获取中台单位编码
     * @param param
     * @return 键是外部系统code+‘-’+单位编码，值是中台单位编码
     */
    @PostMapping("/getUnitMapByName")
    ApiResult<Map<String, String>> getSysUnitByUnitName(@RequestBody List<SysUnitMappingQuaryParam> param);

    /**
     * 根据系统编码和中台单位获取单位转换配置
     * @param param
     * @return fail表示没查到
     */
    @PostMapping("/findUnitByTarget")
    ApiResult<List<SysUnitMappingRpcDTO>> findUnitByTarget(@RequestBody SysUnitMappingQuaryParam param);
}
