package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel("菜品规格参数")
public class ThaliItemSizeRpcDTO implements Serializable {
    private static final long serialVersionUID = 9046865759114285666L;

    @ApiModelProperty("菜品ID")
    private Long thaliItemId;

    @ApiModelProperty("菜品编码")
    private String thaliItemCode;

    @ApiModelProperty("菜品名称")
    private String thaliItemName;

    @ApiModelProperty("菜品单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("销售方式")
    @SysCode(sys = "yst-supp", mod = "THALI_SALE_TYPE")
    private String saleType;
    private String saleTypeName;

    @ApiModelProperty("菜品规格ID")
    private Long sizeId;

    @ApiModelProperty("菜品规格编码")
    private String sizeCode;

    @ApiModelProperty("菜品规格名称")
    private String sizeName;

    @ApiModelProperty("单位转换系数")
    private String sizeWeight;

    @ApiModelProperty("菜品单位2")
    private String sizeWeightUom;
}
