package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author Chris
 * @date 2021-05-24
 */
@Data
@ApiModel("商品BOM详情")
public class ItmItemBomRpcDTO implements Serializable {

    /**
     * 商品BOM ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("商品BOM ID")
    private Long id;

    /**
     * 产品结构关系类型
     */
    @SysCode(sys = "yst-supp", mod = "STRU_RELA")
    @ApiModelProperty(value = "产品结构关系类型")
    private String productStruType;
    private String productStruTypeName;

    /**
     * 产品结构关系编码
     */
    @ApiModelProperty(value = "产品结构关系编码")
    private Long productStruCode;

    /**
     * SPU品牌编号
     */
    @ApiModelProperty(value = "SPU品牌编号")
    private String brand;

    /**
     * SPU品牌名称
     */
    @ApiModelProperty(value = "SPU品牌名称")
    private String brandName;

    /**
     * 商品ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("商品ID")
    private Long itemId;

    /**
     * SKU商品编号
     */
    @ApiModelProperty(value = "SKU商品编号")
    private String itemCode;

    /**
     * SKU商品名称
     */
    @ApiModelProperty(value = "SKU商品名称")
    private String itemName;

    /**
     * SKU商品简称
     */
    @ApiModelProperty(value = "SKU商品简称")
    private String itemAbbr;

    /**
     * SKU商品规格
     */
    @ApiModelProperty(value = "SKU商品规格")
    private String spec;

    /**
     * 通用配件型号
     */
    @ApiModelProperty(value = "通用配件型号")
    private String generalAccessoriesSpec;

    /**
     * ERP编码
     */
    @ApiModelProperty(value = "ERP编码")
    private String erpCode;

    /**
     * ERP名称
     */
    @ApiModelProperty(value = "ERP名称")
    private String erpName;

    /**
     * 数量(主计量单位的数量)
     */
    @ApiModelProperty(value = "数量(主计量单位的数量)")
    private BigDecimal qty;

    /**
     * 基本计量单位
     */
    @ApiModelProperty("基本计量单位 [UDC]COM:UOM")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    /**
     * 父ID
     */
    @ApiModelProperty(value = "父ID")
    private Long pid;

    /**
     * 级别
     */
    @ApiModelProperty(value = "级别")
    private Integer level;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 商品BOM子件清单
     */
    @ApiModelProperty(value = "商品BOM子件清单")
    private List<ItmItemBomRpcDTO> bomRpcDTOS;

    /**
     * 是否启用批次
     */
    @ApiModelProperty(value = "是否启用批次")
    private Boolean lotFlag;

    @ApiModelProperty(value = "保质期天数")
    private Integer guaranteeDays;



    @ApiModelProperty(value = "损耗率")
    private BigDecimal lossRate;

    @ApiModelProperty(value = "权重")
    private BigDecimal weight;

    @ApiModelProperty(value = "是否在经营目录内")
    private Boolean businessItmFlag;

    @ApiModelProperty("基本单位")
    private String uom2;
    @ApiModelProperty(value = "基本单位名称")
    private String uom2Name;

    @ApiModelProperty("单位转换系数")
    private BigDecimal uomRatio;

    @ApiModelProperty("领用单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String receiveUom;
    private String receiveUomName;

    @ApiModelProperty(value = "领用单位转换系数")
    private BigDecimal receiveUomRatio;

    @ApiModelProperty("有效位数")
    private Integer decimalPlaces;

    @ApiModelProperty(value = "类型")
    private String itemType;
    private String itemTypeName;



}
