package com.elitesland.support.provider.sys.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel("外部系统单位查询返回参数")
public class SysUnitMappingRpcDTO implements Serializable {
    private static final long serialVersionUID = 652170017546188416L;
    @ApiModelProperty("主表id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("来源系统编码（udc）")
    @SysCode(sys = "yst-supp", mod = "SYS_SOURCE")
    private String sourceSystemCode;
    private String sourceSystemCodeName;

    @ApiModelProperty("中台单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String targetUnit;
    private String targetUnitName;

    @ApiModelProperty("映射系统单位编码")
    private String sourceUnitCode;

    @ApiModelProperty("映射系统单位名称")
    private String sourceUnitName;

    @ApiModelProperty("是否启用")
    private Integer isActive;
}
