package com.elitesland.support.provider.pri.service.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/3/12
 */
@Data
@ApiModel(value = "价格中心", description = "价格中心查询")
public class PriPriceRpcDTO implements Serializable {
    private static final long serialVersionUID = -1948926768080959006L;

    @ApiModelProperty("价格唯一标识ID")
    private Long id;

    @ApiModelProperty("查询结果标识，与入参的uuid对应")
    private String uuid;

    @ApiModelProperty(value = "价格类型")
    private String priceType;

    @ApiModelProperty(value = "价格类别")
    private String priceCls;

    @ApiModelProperty(value = "含税 价格")
    private BigDecimal price;

    @ApiModelProperty(value = "未税 价格")
    private BigDecimal netPrice;

    @ApiModelProperty(value = "销售组织")
    private String saleOrg;

    @ApiModelProperty(value = "商品编码")
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品类型")
    private String itemType2;

    @ApiModelProperty(value = "基本计量单位")
    private String uom;

    @ApiModelProperty(value = "客户编码")
    private String custCode;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "客户区域")
    @SysCode(sys = "yst-supp", mod = "REGION")
    private String region;
    private String regionName;

    @ApiModelProperty(value = "生产基地")
    @SysCode(sys = "yst-supp", mod = "ORIGIN")
    private String origin;
    private String originName;

    @ApiModelProperty(value = "货币码")
    private String currCode;

    @ApiModelProperty(value = "货币名称")
    private String currName;

    @ApiModelProperty(value = "生效日期")
    private LocalDateTime effectiveDatetime;

    @ApiModelProperty(value = "失效日期")
    private LocalDateTime expiryDatetime;

    @ApiModelProperty(value = "价格状态")
    private String priceStatus;

    private String elementPath;
    private String elementPathValue;

    /**
     * 市场价
     */
    @ApiModelProperty(value = "市场价")
    private BigDecimal price1;

    /**
     * B端指导价
     */
    @ApiModelProperty(value = "B端毛利控制率")
    private BigDecimal price2;

    /**
     * C端零售价
     */
    @ApiModelProperty(value = "C端毛利控制率")
    private BigDecimal price3;

    @ApiModelProperty(value = "税率编号")
    private String taxRateNo;

    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty("公司编号")
    private String ouCode;

    @ApiModelProperty("取价结果备注 记录取价过程")
    private String priceResultNote;

    @ApiModelProperty("价格明细，取价方式为公式时，记录涉及的价格类型明细")
    private List<PriPriceRpcDTO> childPrice;

    @ApiModelProperty("组合商品编号")
    private String combineItemCode;

    @ApiModelProperty("组合商品编号")
    private BigDecimal combineQty;

    @ApiModelProperty("子件父id")
    private Long bomPid;
}
