package com.elitesland.support.provider.dingding.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.dingding.dto.TodoCreateRequestDTO;
import com.elitesland.support.provider.dingding.dto.WorkCreateRequestDTO;
import com.elitesland.support.provider.org.service.OrgAddrRpcService;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @author zhiyu.he
 * @date 2025/10/21 10:38
 */
@FeignClient(name = Application.NAME, path = Application.PATH + DingDingRpcService.PATH)
@Validated
public interface DingDingRpcService {
    String PATH = "/dingDing";


    @PostMapping("/createTodo")
    ApiResult<String> createTodo(TodoCreateRequestDTO request);

    @PostMapping("/updateTodo")
    ApiResult<String>  updateTodo(TodoCreateRequestDTO request);

    @PostMapping("/createWork")
    ApiResult<String>  createWork(WorkCreateRequestDTO request);

    @PostMapping("/updateWork")
    ApiResult<String>  updateWork(WorkCreateRequestDTO request);

    @GetMapping("/getDingDingUserIdByUserId/{userId}")
    ApiResult<String>  getDingDingUserIdByUserId(@PathVariable("userId") Long userId);

    @GetMapping("/getDingDingUnionIdByUserId/{userId}")
    ApiResult<String>  getDingDingUnionIdByUserId(@PathVariable("userId") Long userId);
}
