package com.elitesland.support.provider.org.param;

import com.elitescloud.boot.core.support.customfield.common.AbstractCustomFieldQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author Chris
 * @date 2021-05-28
 */
@Data
@ApiModel("地址薄-地址信息DTO查询参数")
public class OrgAddressRpcDtoParam extends AbstractCustomFieldQueryParam implements Serializable {

    private static final long serialVersionUID = 6668767482549077384L;

    /**
     * id 列表
     */
    @ApiModelProperty("id 列表")
    private List<Long> ids;

    /**
     * 地址号列表
     */
    @ApiModelProperty("地址号列表")
    private List<Long> addrNos;

    /**
     * 地址类型(指送货地址，开票地址等):[UDC]ORG:ADDRESS_TYPE
     */
    @ApiModelProperty("地址类型(指送货地址，开票地址等):[UDC]ORG:ADDRESS_TYPE")
    private String addressType;

    /**
     * 是否默认：true是，false否
     */
    @ApiModelProperty("是否默认：true是，false否")
    private Boolean defaultFlag;

    /**
     * 联系人姓名，支持模糊查询
     */
    @ApiModelProperty("联系人姓名，支持模糊查询")
    private String contPerson;

    /**
     * 手机号码，支持模糊查询
     */
    @ApiModelProperty("手机号码，支持模糊查询")
    private String mobile;

    /**
     * 电话，支持模糊查询
     */
    @ApiModelProperty("电话，支持模糊查询")
    private String tel;

    /**
     * 数据来源
     */
    @ApiModelProperty("数据来源")
    private List<String> dataSources;
}
