package com.elitesland.support.provider.thaliItem.service;

import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.item.dto.StoreThaliItemRespRpcDto;
import com.elitesland.support.provider.item.dto.ThaliItemNewRpcDTO;
import com.elitesland.support.provider.item.dto.ThaliItemSizeRpcDTO;
import com.elitesland.support.provider.item.param.StoreThaliItemRpcDtoParam;
import com.elitesland.support.provider.item.param.ThaliItemRpcDtoParam;
import com.elitesland.support.provider.thaliItem.dto.ThaliItemInvQuantityRpcDto;
import com.elitesland.support.provider.thaliItem.param.ThaliItemInvQuantityQueryRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author Chris
 * @date 2021-04-27
 */
@FeignClient(name = Application.NAME, path = Application.PATH + ThaliItemRpcService.PATH)
@Validated
public interface ThaliItemRpcService {
    String PATH = "/thaliItemRpc";

    /**
     * 通过参数查询ThaliItemRpcDTO列表
     */
    @PostMapping("/findThaliItemRpcDto")
    List<ThaliItemNewRpcDTO> findThaliItemRpcDtoByParam(@RequestBody ThaliItemRpcDtoParam param);

    @PostMapping("/findThaliItemsByCode")
    List<ThaliItemNewRpcDTO> findThaliItemsByCode(@RequestBody ThaliItemRpcDtoParam param);

    @PostMapping("/queryInvQuantityByCode")
    List<ThaliItemInvQuantityRpcDto> queryInvQuantityByCode(@RequestBody ThaliItemInvQuantityQueryRpcParam param);

    @PostMapping("/findStoreThaliItem")
    List<StoreThaliItemRespRpcDto> findStoreThaliItemRpcDtoByParam(@RequestBody StoreThaliItemRpcDtoParam param);

    @PostMapping("/findThaliItemBySizeCode")
    List<ThaliItemSizeRpcDTO> findThaliItemBySizeCode(@RequestBody List<String> sizeCodes);

}
