package com.elitesland.support.provider.item.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 06月 27日 10:27
 * @version: 1.0
 */
@Data
@ApiModel("商品单位及转换信息信息")
public class ItmUomRpcDTO implements Serializable {

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty(name = "有效小数为准")
    private Integer decimalPlaces;

    @ApiModelProperty(name = "商品单位信息")
    private List<ItemUomDetail> itemUomList;

    @Data
    public static class ItemUomDetail implements Serializable{

        @ApiModelProperty("单位编码")
        private String uomCode;

        @ApiModelProperty("单位名称")
        private String uomName;

        @ApiModelProperty("业务单位到基本单位的转换系数")
        private BigDecimal ratio;

        @ApiModelProperty("基本单位到业务单位转换系数")
        private BigDecimal ratioRevert;

        @ApiModelProperty("是否默认")
        private Boolean defaultFlag;


        public Boolean getDefaultFlag() {
            return this.defaultFlag == null ? Boolean.FALSE : this.defaultFlag;
        }
    }





}
