package com.elitesland.support.provider.org.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

@Data
@ApiModel("加盟商列表返回参数")
public class OrgFranchiseeRpcDTO implements Serializable {

    private static final long serialVersionUID = -9077656869923559817L;

    @ApiModelProperty("主表id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("加盟商代码")
    private String franchiseeCode;

    @ApiModelProperty("加盟商名称")
    private String franchiseeName;

    @ApiModelProperty("加盟商证件号")
    private String franchiseeDocNo;

    @ApiModelProperty("加盟商联系电话")
    private String franchiseePhone;

    @ApiModelProperty("加盟商状态")
    private String franchiseeStatus;
    @ApiModelProperty("加盟商状态名")
    private String franchiseeStatusName;

    @ApiModelProperty("加盟时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDateTime joinTime;

    @ApiModelProperty("实体类型")
    private String entityType;
    @ApiModelProperty("实体类型名")
    private String entityTypeName;

    @ApiModelProperty("基本信息")
    private BasicInfo basicInfo;

    @ApiModelProperty("身份证照片")
    private IdCardPhotos idCardPhotos;

    @ApiModelProperty("个人相关信息")
    private IndividualInfo individualInfo;

    @ApiModelProperty("企业相关信息")
    private EnterpriseInfo enterpriseInfo;

    @ApiModelProperty("业绩指标")
    private PerformanceMetrics performanceMetrics;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("数据源")
    private String dataSource;

    @ApiModelProperty(value = "同步状态")
    private String syncStatus;
    private String syncStatusName;

    @ApiModelProperty(value = "同步错误信息")
    private String syncError;

    @ApiModelProperty(value = "外部系统KEY")
    private String outSysKey;

    @Data
    public static class BasicInfo {
        @ApiModelProperty("姓名")
        private String name;

        @ApiModelProperty("性别")
        private String gender;
        @ApiModelProperty("性别名")
        private String genderName;

        @ApiModelProperty("出生日期")
        @JsonFormat(pattern = "yyyy-MM-dd")
        private LocalDateTime birthDate;

        @ApiModelProperty("籍贯")
        private String origin;

        @ApiModelProperty("身份证号码")
        private String idNumber;

        @ApiModelProperty("电子邮箱")
        private String email;
    }

    @Data
    public static class IdCardPhotos {
        @ApiModelProperty("身份证人像面照片URL")
        private String portraitSide;

        @ApiModelProperty("身份证国徽面照片URL")
        private String nationalEmblemSide;
    }

    @Data
    public static class IndividualInfo {
        @ApiModelProperty("签署人姓名")
        private String signatoryName;

        @ApiModelProperty("签署人证件类型")
        private String signatoryDocType;
        @ApiModelProperty("签署人证件类型名")
        private String signatoryDocTypeName;

        @ApiModelProperty("签署人证件号")
        private String signatoryDocNumber;

        @ApiModelProperty("签署人电话")
        private String signatoryPhone;
    }

    @Data
    public static class EnterpriseInfo {
        @ApiModelProperty("公司名称")
        private String companyName;

        @ApiModelProperty("统一社会信用代码")
        private String creditCode;

        @ApiModelProperty("法定代表人姓名")
        private String legalPersonName;

        @ApiModelProperty("法定代表人证件类型")
        private String legalPersonDocType;
        @ApiModelProperty("法定代表人证件类型名")
        private String legalPersonDocTypeName;

        @ApiModelProperty("法定代表人身份类型")
        private String legalPersonIdentity;
        @ApiModelProperty("法定代表人身份类型名")
        private String legalPersonIdentityName;

        @ApiModelProperty("法定代表人证件号")
        private String legalPersonDocNumber;

        @ApiModelProperty("法定代表人手机号")
        private String legalPersonMobile;

        @ApiModelProperty("注册资本")
        private Integer registeredCapital;

        @ApiModelProperty("成立日期")
        @JsonFormat(pattern = "yyyy-MM-dd")
        private LocalDateTime establishmentDate;

        @ApiModelProperty("营业执照照片URL")
        private String businessLicensePhoto;
    }

    @Data
    public static class PerformanceMetrics {
        @ApiModelProperty("总积分")
        private Integer totalPoints;

        @ApiModelProperty("等级")
        private String level;

        @ApiModelProperty("门店数量")
        private Integer storeCount;

        @ApiModelProperty("终止数量")
        private Integer terminatedCount;
    }
    public static OrgFranchiseeRpcDTO convertDODTOToDtoPageDTO(OrgFranchiseeDODTO doObj) {
        if (doObj == null) {
            return null;
        }
        OrgFranchiseeRpcDTO orgFranchiseeRpcDTO = new OrgFranchiseeRpcDTO();

        // 使用BeanUtils复制直接对齐的字段
        BeanUtils.copyProperties(doObj, orgFranchiseeRpcDTO);
        //加盟商状态：ACTIVE(活跃)/INACTIVE(非活跃)，以下字段在OrgUdcEnum中有进行配置，如有修改请手动添加
        if (orgFranchiseeRpcDTO.getFranchiseeStatus().equals("ACTIVE")) {
            orgFranchiseeRpcDTO.setFranchiseeStatusName("活跃");
        } else {
            orgFranchiseeRpcDTO.setFranchiseeStatusName("非活跃");
        }
        // 加盟商主体类型：PERSON(个人)/ENTERPRISE(企业)
        if (orgFranchiseeRpcDTO.getEntityType().equals("PERSON")) {
            orgFranchiseeRpcDTO.setEntityTypeName("个人");
        } else {
            orgFranchiseeRpcDTO.setEntityTypeName("企业");
        }
        // 处理BasicInfo对象
        OrgFranchiseeRpcDTO.BasicInfo basicInfo = new OrgFranchiseeRpcDTO.BasicInfo();
        basicInfo.setName(doObj.getBasicInfoName());
        basicInfo.setGender(doObj.getBasicInfoGender());
        basicInfo.setBirthDate(doObj.getBasicInfoBirthDate());
        basicInfo.setOrigin(doObj.getBasicInfoOrigin());
        basicInfo.setIdNumber(doObj.getBasicInfoIdNumber());
        basicInfo.setEmail(doObj.getBasicInfoEmail());
        // 性别：MALE(男)/FEMALE(女)
        if ("MALE".equals(basicInfo.getGender())) {
            basicInfo.setGenderName("男");
        } else if( "FEMALE".equals(basicInfo.getGender())) {
            basicInfo.setGenderName("女");
        }
        orgFranchiseeRpcDTO.setBasicInfo(basicInfo);

        // 处理IdCardPhotos对象
        OrgFranchiseeRpcDTO.IdCardPhotos idCardPhotos = new OrgFranchiseeRpcDTO.IdCardPhotos();
        idCardPhotos.setPortraitSide(doObj.getIdCardPhotosPortraitSide());
        idCardPhotos.setNationalEmblemSide(doObj.getIdCardPhotosNationalEmblemSide());
        orgFranchiseeRpcDTO.setIdCardPhotos(idCardPhotos);

        // 处理IndividualInfo对象
        OrgFranchiseeRpcDTO.IndividualInfo individualInfo = new OrgFranchiseeRpcDTO.IndividualInfo();
        individualInfo.setSignatoryName(doObj.getIndividualInfoSignatoryName());
        individualInfo.setSignatoryDocType(doObj.getIndividualInfoSignatoryDocType());
        individualInfo.setSignatoryDocNumber(doObj.getIndividualInfoSignatoryDocNumber());
        individualInfo.setSignatoryPhone(doObj.getIndividualInfoSignatoryPhone());
        // 签约人证件类型：ID_CARD(身份证)/PASSPORT(护照)
        if ("ID_CARD".equals(individualInfo.getSignatoryDocType())) {
            individualInfo.setSignatoryDocTypeName("身份证");
        } else if ("PASSPORT".equals(individualInfo.getSignatoryDocType())) {
            individualInfo.setSignatoryDocTypeName("护照");
        }
        orgFranchiseeRpcDTO.setIndividualInfo(individualInfo);

        // 处理EnterpriseInfo对象
        OrgFranchiseeRpcDTO.EnterpriseInfo enterpriseInfo = new OrgFranchiseeRpcDTO.EnterpriseInfo();
        enterpriseInfo.setCompanyName(doObj.getEnterpriseInfoCompanyName());
        enterpriseInfo.setCreditCode(doObj.getEnterpriseInfoCreditCode());
        enterpriseInfo.setLegalPersonName(doObj.getEnterpriseInfoLegalPersonName());
        enterpriseInfo.setLegalPersonDocType(doObj.getEnterpriseInfoLegalPersonDocType());
        enterpriseInfo.setLegalPersonIdentity(doObj.getEnterpriseInfoLegalPersonIdentity());
        enterpriseInfo.setLegalPersonMobile(doObj.getEnterpriseInfoLegalPersonMobile());
        enterpriseInfo.setRegisteredCapital(doObj.getEnterpriseInfoRegisteredCapital());
        enterpriseInfo.setEstablishmentDate(doObj.getEnterpriseInfoEstablishmentDate());
        enterpriseInfo.setBusinessLicensePhoto(doObj.getEnterpriseInfoBusinessLicensePhoto());
        enterpriseInfo.setLegalPersonDocNumber(doObj.getEnterpriseInfoLegalPersonDocNumber());
        // 法人证件类型：ID_CARD(身份证)/PASSPORT(护照)
        // 法人身份：LEGAL_PERSON(法人)/SHAREHOLDER(股东)
        if ("ID_CARD".equals(enterpriseInfo.getLegalPersonDocType())) {
            enterpriseInfo.setLegalPersonDocTypeName("身份证");
        } else if ("PASSPORT".equals(enterpriseInfo.getLegalPersonDocType())) {
            enterpriseInfo.setLegalPersonDocTypeName("护照");
        }
        if ("LEGAL_PERSON".equals(enterpriseInfo.getLegalPersonIdentity())) {
            enterpriseInfo.setLegalPersonIdentityName("法人");
        } else if ("SHAREHOLDER".equals(enterpriseInfo.getLegalPersonIdentity())) {
            enterpriseInfo.setLegalPersonIdentityName("股东");
        }
        orgFranchiseeRpcDTO.setEnterpriseInfo(enterpriseInfo);

        // 处理PerformanceMetrics对象
        OrgFranchiseeRpcDTO.PerformanceMetrics performanceMetrics = new OrgFranchiseeRpcDTO.PerformanceMetrics();
        performanceMetrics.setTotalPoints(doObj.getPerformanceMetricsTotalPoints());
        performanceMetrics.setLevel(doObj.getPerformanceMetricsLevel());
        performanceMetrics.setStoreCount(doObj.getPerformanceMetricsStoreCount());
        performanceMetrics.setTerminatedCount(doObj.getPerformanceMetricsTerminatedCount());
        orgFranchiseeRpcDTO.setPerformanceMetrics(performanceMetrics);

        return orgFranchiseeRpcDTO;
    }
    public static List<OrgFranchiseeRpcDTO> convertDODTOToDtoPageDTO(List<OrgFranchiseeDODTO> dto) {
        if (dto == null) {
            return null;
        }
        return dto.stream().map(OrgFranchiseeRpcDTO::convertDODTOToDtoPageDTO).collect(Collectors.toList());
    }
}
