package com.elitesland.support.provider.org.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel("门店列表返回参数")
public class OrgStoreRpcDTO implements  Serializable {

    private static final long serialVersionUID = 7642742820400617474L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "主健")
    private Long id;


    @ApiModelProperty(value = "盟食亿ID")
    private String msyStoreId;

    @ApiModelProperty(value = "申请单号")
    private String applyNo;

    /**
     * 门店ID
     */
    @ApiModelProperty(value = "门店ID")
    private String storeCode;

    /**
     * 门店编号
     */
    @ApiModelProperty(value = "门店编号")
    private String storeCode2;

    /**
     * 门店名称
     */
    @ApiModelProperty(value = "门店名称")
    private String storeName;


    /**
     * 门店类型2
     */
    @ApiModelProperty(value = "经营性质")
    @SysCode(sys = "yst-supp", mod = "STORE_TYPE2")
    private String storeType2;
    private String storeType2Name;


    /**
     * 门店类型3
     */
    @ApiModelProperty(value = "店面性质")
    @SysCode(sys = "yst-supp", mod = "STORE_TYPE3")
    private String storeType3;
    private String storeType3Name;

    /**
     * 所属上级组织
     */
    @ApiModelProperty(value = "所属上级组织")
    private Long pid;
    private String pname;
    @ApiModelProperty(value = "所属上级组织")
    private String pcode;

    @ApiModelProperty(value = "所属经销商名称 客户简称")
    private String ouName;

    @ApiModelProperty(value = "所属经销商名称 客户简称")
    private String ouCode;


    /**
     * 店面等级
     */
    @ApiModelProperty(value = "店面等级")
    private String storeLevel;
    private String storeLevelName;

    /**
     * 营业时间段
     */
    @ApiModelProperty(value = "营业时间段")
    private LocalDateTime openTimeSpanStart;


    @ApiModelProperty(value = "营业时间段")
    private LocalDateTime openTimeSpanEnd;

    /**
     * 门店间数
     */
    @ApiModelProperty(value = "门店间数")
    private int storeRoom;

    /**
     * 店铺面积
     */
    @ApiModelProperty(value = "店铺面积")
    private BigDecimal storeArea;

    /**
     * 门店标签
     */
    @ApiModelProperty(value = "门店标签")
    private List<String> storeTags;

    /**
     * 门店标签名称
     */
    @ApiModelProperty(value = "门店标签名称")
    private List<String> storeTagNames;

    /**
     * 所属组织ID
     */
    @ApiModelProperty(value = "所属组织ID")
    private Long buId;

    /**
     * 所属组织名称
     */
    @ApiModelProperty(value = "所属组织名称")
    private String buName;

    /**
     * 所属组织编码
     */
    @ApiModelProperty(value = "所属组织编码")
    private String buCode;

    /**
     * 门店类型
     */
    @ApiModelProperty(value = "门店类型")
    @SysCode(sys = "yst-supp", mod = "STORE_TYPE")
    private String storeType;
    private String storeTypeName;

    /**
     * 门店状态
     */
    @ApiModelProperty(value = "门店状态")
    @SysCode(sys = "yst-supp", mod = "STORE_STATUS")
    private String storeStatus;
    private String storeStatusName;

    @ApiModelProperty("地址号")
    private Long addrNo;

    @ApiModelProperty(value = "联系电话")
    private String storeContPhone;

    @ApiModelProperty(value = "门店负责人")
    private String storeManager;

    @ApiModelProperty(value = "门店地址")
    private String address;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新人")
    private String updater;

    @ApiModelProperty(value = "到店距離")
    private double distance;

    @ApiModelProperty("更新时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty("门店登录账号")
    private String storeUser;


    @ApiModelProperty("业务员ID")
    private Long agentEmpId;

    @ApiModelProperty("业务员名称")
    private String agentEmpName;

    @ApiModelProperty("业务员编码")
    private String agentEmpCode;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户号")
    private String custCode2;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("客户简称")
    private String custAbbr;

    /**
     * 区域负责人
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "区域负责人")
    private String regionRespPerson;

    /**
     * 渠道类型（线上，线下）
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "渠道类型（线上，线下）")
    @SysCode(sys = "yst-supp", mod = "CHANNEL_TYPE")
    private String channelType;

    private String channelTypeName;




    /**
     * 渠道编码
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "渠道编码")
    @SysCode(sys = "yst-supp", mod = "STORE_CHANNEL")
    private String channelCode;

    @ApiModelProperty(value = "渠道编码")
    private String channelCodeName;

    /**
     * 渠道名称
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "渠道名称")
    private String channelName;

    /**
     * 客户id
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "客户id")
    private String custId;


    /**
     * 商户号
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "商户号")
    private String merchantIdNum;

    /**
     * 成本中心编码
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "成本中心编码")
    private String costCode;

    /**
     * 品牌id
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "品牌id")
    private String brandId;

    /**
     * 品牌编码
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "品牌编码")
    private String brandCode;

    /**
     * 品牌名称
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "  品牌名称")
    private String brandName;

    /**
     * 品牌中文名
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "品牌中文名")
    private String brandEnName;

    @ApiModelProperty(value = "区域 []yst-supp:REGION")
//    @SysCode(sys = "yst-supp", mod = "REGION")
    private String region;
    private String regionName;

    @ApiModelProperty(value = "ERP外部编码")
    private String outerCode;

    @ApiModelProperty(value = "营业生效时间")
    private LocalDateTime openTime;

    @ApiModelProperty(value = "门店冻结时间")
    private LocalDateTime closeTime;

    @ApiModelProperty("建筑类型")
    private String buildingType;

    @ApiModelProperty("创建状态")
    private String createStatus;


    @ApiModelProperty("是否补充运费")
    private Boolean fillFreightFlag;

    @ApiModelProperty("免运费数量")
    private Integer freeFreightNum;

    @ApiModelProperty("补运费单价")
    private BigDecimal fillFreightPrice;






}
