package com.elitesland.support.provider.sys.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
@ApiModel("系统单位映射查询参数")
public class SysUnitMappingQuaryParam implements Serializable {
    private static final long serialVersionUID = 4128004870439912158L;

    @ApiModelProperty("主表id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("来源系统编码（udc）")
    private String sourceSystemCode;

    @ApiModelProperty("映射系统单位编码")
    private String sourceUnitCode;

    @ApiModelProperty("映射系统单位名称")
    private String sourceUnitName;

    @ApiModelProperty("中台单位")
    private List<String> targetUnitList;
}
