package com.elitesland.support.provider.org.param;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;

import java.nio.charset.StandardCharsets;

public interface DataHash {
    public default String getHash(){
        HashFunction hashFunction = Hashing.sha256();
        Object[] content = waitHashContent();
        if(content==null||content.length==0){
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Object o : content) {
            sb.append(o);
        }
        return hashFunction.hashString(sb.toString(), StandardCharsets.UTF_8).toString();
    }

    public Object[] waitHashContent();

}
